package uk.ac.warwick.util.ais.core.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Test;

import java.io.IOException;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

public class EmptyStringToNullDeserialiserTest {

    private final ObjectMapper objectMapper = new ObjectMapper();
    private final EmptyStringToNullTransformer transformer = new EmptyStringToNullTransformer();
    private final PipelineStringDeserializer deserialiser = new PipelineStringDeserializer(transformer);

    @Test
    public void deserialize_notEmptyString_returnStringValue() throws IOException {
        String json = "{\n" +
                "  \"SAB_OFF\": \"2018-10-03T07:24:14.772+03:00\",\n" +
                "  \"SAB_EMPTY\": \"\"\n" +
                "}";

        JsonNode jsonNode = objectMapper.readTree(json);
        JsonParser noneEmptyNode = jsonNode.get("SAB_OFF").traverse();
        noneEmptyNode.nextToken();
        assertEquals("2018-10-03T07:24:14.772+03:00", deserialiser.deserialize(noneEmptyNode, null));
    }

    @Test
    public void deserialize_emptyString_returnNull() throws IOException {
        String json = "{\n" +
                "  \"SAB_OFF\": \"2018-10-03T07:24:14.772+03:00\",\n" +
                "  \"SAB_EMPTY\": \"\"\n" +
                "}";

        JsonNode jsonNode = objectMapper.readTree(json);
        JsonParser emptyNode = jsonNode.get("SAB_EMPTY").traverse();
        emptyNode.nextToken();
        assertNull(deserialiser.deserialize(emptyNode, null));
    }
}
