package uk.ac.warwick.util.ais.core.properties;

/**
 * Interface to provide the properties required for the AIS API.
 */
public interface AisApimProperties {

    /**
     * Channel ID is a unique identifier that is unique for a business or comms channel.
     *
     * @return bapi channel id
     */
    String getBapiChannelId();

    /**
     * App ID is unique for a api consuming application.
     *
     * @return App Id
     */
    String getBapiAppId();

    /**
     * Api base Url
     *
     * @return base url
     */
    String getBaseUrl();

}
