package uk.ac.warwick.util.ais.core.json;

import java.util.List;

/**
 * A {@link StringTransformer} that applies a sequence of transformation steps to a String input.
 *
 * <p>This class implements the <b>pipeline pattern</b>, where each {@link StringTransformer} in the list
 * transforms the result of the previous step. The output of the entire chain is the result of the final
 * transformer.</p>
 */
public class ChainedTransformer implements StringTransformer {

    /**
     * Ordered list of transformation steps to be applied.
     */
    private final List<StringTransformer> transformSteps;

    public ChainedTransformer(List<StringTransformer> transformSteps) {
        this.transformSteps = transformSteps;
    }

    /**
     * Applies each transformation step in order to the input string.
     *
     * @param input the original string to be transformed
     * @return the fully transformed string after all steps
     */
    @Override
    public String transform(String input) {
        String result = input;
        for (StringTransformer step : transformSteps) {
            result = step.transform(result);
        }
        return result;
    }
}
