package uk.ac.warwick.util.ais.core.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import uk.ac.warwick.util.ais.core.exception.AisJsonProcessingException;

public interface AisJsonConverter {

    <T> T fromJsonNode(JsonNode json, TypeReference<T> typeReference) throws AisJsonProcessingException;

    <T> T fromJsonNode(JsonNode json, Class<T> clazz) throws AisJsonProcessingException;

    <T> T fromJsonString(String json, TypeReference<T> typeReference) throws AisJsonProcessingException;

    <T> T fromJsonString(String json, Class<T> clazz) throws AisJsonProcessingException;

    String toJsonString(Object obj) throws AisJsonProcessingException;

    JsonNode toJsonNode(String json) throws AisJsonProcessingException;
}
