package uk.ac.warwick.util.ais.core.httpclient;

import java.util.concurrent.CompletableFuture;

/**
 * This interface provides a method to execute http requests asynchronously and return the response as a CompletableFuture.
 * It helps separate the concern of AisHttpAsyncClient when sending requests without actually having to care about how they will be executed.
 * This makes it easy to support both Apache HttpClient (mostly used with Spring) and WSClient (used on Play)
 * by simply creating concrete implementations of this HttpRequestExecutor.
 *
 * @param <R> the request object
 * @param <T> the response object
 */
@FunctionalInterface
public interface HttpRequestExecutor<R, T> {

    /**
     * Execute a request asynchronously and return a CompletableFuture object.
     * CompletableFuture is a Java class that extends Future and provides a way to handle the result of an asynchronous computation.
     *
     * @param request the request object
     * @return A CompletableFuture<T> object
     */
    CompletableFuture<T> execute(R request);
}
