package uk.ac.warwick.util.ais.auth.model;

import uk.ac.warwick.util.ais.auth.credentials.OAuth2ClientCredentials;

public class OAuth2TokenFetchParameters {

    private final OAuth2ClientCredentials credentials;

    /**
     * Scope for which the application is requesting access to.
     */
    private final String scope;

    public OAuth2TokenFetchParameters(OAuth2ClientCredentials credentials, String scope) {
        this.credentials = credentials;
        this.scope = scope;
    }

    public String getAuthority() {
        return this.credentials.getAuthority();
    }

    public String getClientId() {
        return this.credentials.getClientId();
    }

    public String getClientSecret() {
        return this.credentials.getClientSecret();
    }

    public String getScope() {
        return this.scope;
    }

    public String getGrantType() {
        return "client_credentials";
    }
}
