package uk.ac.warwick.util.ais.auth.model;

import uk.ac.warwick.util.ais.auth.token.AccessToken;

import java.time.Instant;

public class ClientCredentialsResult implements AuthenticationResult {

    private final String scope;

    private final String accessToken;

    private final String tokenType;

    private final Instant expiryTime;

    public ClientCredentialsResult(String scope, AccessToken accessToken) {
        this.scope = scope;
        this.accessToken = accessToken.getTokenValue();
        this.tokenType = accessToken.getTokenType();
        this.expiryTime = accessToken.getExpiryTime();
    }

    public String getAccessToken() {
        return accessToken;
    }

    public String getTokenType() {
        return tokenType;
    }

    public boolean isExpired() {
        return expiryTime.isBefore(Instant.now());
    }

    public boolean isExpiringAfter(int seconds) {
        return expiryTime.isBefore(Instant.now().plusSeconds(seconds));
    }

    public String getScope() {
        return scope;
    }
}
