package uk.ac.warwick.util.ais.auth;

import uk.ac.warwick.util.ais.auth.exception.AuthenticationException;
import uk.ac.warwick.util.ais.auth.model.AuthenticationResult;

/**
 * This interface will provide a method to retrieve the Authorized access token
 * the Authorization information would be attached to each HTTP request.
 */
@FunctionalInterface
public interface Authenticator<T, R extends AuthenticationResult> {

    /**
     * Authenticates based on the given request and returns an authentication result.
     *
     * @param request the authentication request
     * @return the authentication result
     * @throws AuthenticationException if authentication fails
     */
    R authenticate(T request) throws AuthenticationException;
}
