/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.sso.client.util.cookies;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import uk.ac.warwick.sso.client.core.Cookie;
import uk.ac.warwick.sso.client.util.cookies.CookieEncoder;
import uk.ac.warwick.sso.client.util.cookies.CookieUtil;
import uk.ac.warwick.sso.client.util.cookies.HttpHeaderDateFormat;
import uk.ac.warwick.util.core.DateTimeUtils;
import uk.ac.warwick.util.core.StringUtils;

public final class ServerCookieEncoder
extends CookieEncoder {
    public ServerCookieEncoder(boolean bl) {
        super(bl);
    }

    public String encode(String string, String string2) {
        return this.encode(new Cookie(string, string2));
    }

    public String encode(Cookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie");
        }
        String string = cookie.getName();
        String string2 = cookie.getValue() != null ? cookie.getValue() : "";
        this.validateCookie(string, string2);
        StringBuilder stringBuilder = new StringBuilder();
        CookieUtil.add(stringBuilder, string, string2);
        if (cookie.getMaxAge() >= 0) {
            CookieUtil.add(stringBuilder, "Max-Age", cookie.getMaxAge());
            Instant instant = cookie.getMaxAge() <= 0 ? Instant.ofEpochSecond(0L) : Instant.now(DateTimeUtils.CLOCK_IMPLEMENTATION).plusSeconds(cookie.getMaxAge());
            CookieUtil.add(stringBuilder, "Expires", HttpHeaderDateFormat.get().format(Date.from(instant)));
        }
        if (cookie.getSameSite() != null) {
            switch (cookie.getSameSite()) {
                case STRICT: {
                    CookieUtil.add(stringBuilder, "SameSite", "Strict");
                    break;
                }
                case LAX: {
                    CookieUtil.add(stringBuilder, "SameSite", "Lax");
                    break;
                }
                case NONE: {
                    CookieUtil.add(stringBuilder, "SameSite", "None");
                }
            }
        }
        if (StringUtils.hasText((String)cookie.getPath())) {
            CookieUtil.add(stringBuilder, "Path", cookie.getPath());
        }
        if (StringUtils.hasText((String)cookie.getDomain())) {
            CookieUtil.add(stringBuilder, "Domain", cookie.getDomain());
        }
        if (cookie.isSecure()) {
            CookieUtil.add(stringBuilder, "Secure");
        }
        if (cookie.isHttpOnly()) {
            CookieUtil.add(stringBuilder, "HTTPOnly");
        }
        return CookieUtil.stripTrailingSeparator(stringBuilder);
    }

    public List<String> encode(Cookie ... cookieArray) {
        if (cookieArray == null) {
            throw new NullPointerException("cookies");
        }
        if (cookieArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(cookieArray.length);
        for (Cookie cookie : cookieArray) {
            if (cookie == null) break;
            arrayList.add(this.encode(cookie));
        }
        return arrayList;
    }

    public List<String> encode(Collection<? extends Cookie> collection) {
        if (collection == null) {
            throw new NullPointerException("cookies");
        }
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (Cookie cookie : collection) {
            if (cookie == null) break;
            arrayList.add(this.encode(cookie));
        }
        return arrayList;
    }

    public List<String> encode(Iterable<? extends Cookie> iterable) {
        if (iterable == null) {
            throw new NullPointerException("cookies");
        }
        if (iterable.iterator().hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Cookie cookie : iterable) {
            if (cookie == null) break;
            arrayList.add(this.encode(cookie));
        }
        return arrayList;
    }
}

