/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.sso.client.trusted;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.sso.client.HandleFilter;
import uk.ac.warwick.sso.client.SSOClientFilter;
import uk.ac.warwick.sso.client.SSOConfigLoader;
import uk.ac.warwick.sso.client.SSOConfiguration;
import uk.ac.warwick.sso.client.SSOHandler;
import uk.ac.warwick.sso.client.trusted.SSOConfigTrustedApplicationsManager;
import uk.ac.warwick.sso.client.trusted.TrustedApplicationHandler;
import uk.ac.warwick.sso.client.trusted.TrustedApplicationHandlerImpl;
import uk.ac.warwick.sso.client.trusted.TrustedApplicationsManager;
import uk.ac.warwick.userlookup.UserLookup;
import uk.ac.warwick.userlookup.UserLookupInterface;

public class TrustedApplicationFilter
extends HandleFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrustedApplicationFilter.class);
    private TrustedApplicationHandler handler;
    private SSOConfiguration config;
    private String configSuffix = "";
    private String configLocation;
    private TrustedApplicationsManager trustedApplicationsManager;
    private UserLookupInterface userLookup;

    public void setConfigLocation(String string) {
        this.configLocation = string;
    }

    public void setConfigSuffix(String string) {
        this.configSuffix = string;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig.getInitParameter("configsuffix") != null) {
            this.configSuffix = filterConfig.getInitParameter("configsuffix");
        }
        if (this.config == null) {
            ServletContext servletContext = filterConfig.getServletContext();
            this.config = (SSOConfiguration)servletContext.getAttribute("SSO-CONFIG" + this.configSuffix);
            if (this.config == null) {
                LOGGER.warn("Could not find sso config in servlet context attribute SSO-CONFIG" + this.configSuffix + "; attempting to load sso config");
                SSOConfigLoader sSOConfigLoader = new SSOConfigLoader();
                sSOConfigLoader.loadSSOConfig(servletContext);
                this.config = (SSOConfiguration)servletContext.getAttribute("SSO-CONFIG" + this.configSuffix);
            }
            if (this.config == null) {
                LOGGER.warn("Could not find sso config in servlet context attribute SSO-CONFIG" + this.configSuffix);
            } else {
                LOGGER.info("Found sso config");
            }
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (SSOClientFilter.getUserFromRequest((HttpServletRequest)servletRequest).isFoundUser()) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            this.filterWithHandler((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
        }
    }

    public void destroy() {
    }

    @Override
    public SSOConfiguration getConfig() {
        return this.config;
    }

    @Override
    public SSOHandler getHandler() {
        if (this.handler == null) {
            this.handler = new TrustedApplicationHandlerImpl(this.getUserLookup(), this.getTrustedApplicationsManager(), this.getConfig());
        }
        return this.handler;
    }

    public void setHandler(TrustedApplicationHandler trustedApplicationHandler) {
        this.handler = trustedApplicationHandler;
    }

    public void setConfig(SSOConfiguration sSOConfiguration) {
        this.config = sSOConfiguration;
    }

    public UserLookupInterface getUserLookup() {
        if (this.userLookup == null) {
            this.userLookup = UserLookup.getInstance();
        }
        return this.userLookup;
    }

    public void setUserLookup(UserLookupInterface userLookupInterface) {
        this.userLookup = userLookupInterface;
        if (this.handler != null) {
            this.handler.setUserLookup(userLookupInterface);
        }
    }

    public TrustedApplicationsManager getTrustedApplicationsManager() {
        if (this.trustedApplicationsManager == null) {
            try {
                this.trustedApplicationsManager = new SSOConfigTrustedApplicationsManager(this.getConfig());
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return this.trustedApplicationsManager;
    }

    public void setTrustedApplicationsManager(TrustedApplicationsManager trustedApplicationsManager) {
        this.trustedApplicationsManager = trustedApplicationsManager;
    }
}

