/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.sso.client.tags;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.sso.client.SSOConfiguration;
import uk.ac.warwick.util.core.StringUtils;

public class SSOLinkGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSOLinkGenerator.class);
    private String _target;
    private Configuration _config;
    private HttpServletRequest _request;

    public SSOLinkGenerator() {
        this.setConfig((Configuration)SSOConfiguration.getConfig());
    }

    public final void setTarget(String string) {
        this._target = string;
    }

    public final String getTarget() {
        Object object = this._target;
        if (object != null && !((String)object).equals("")) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using target specifically passed in:" + (String)object);
            }
            return object;
        }
        if (this.getRequest() == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found not HttpServletRequest to get url information from, returning empty target");
            }
            return "";
        }
        object = this.getRequest().getRequestURL().toString();
        if (this.getRequest().getQueryString() != null && StringUtils.hasText((String)this.getRequest().getQueryString())) {
            object = (String)object + "?" + this.getRequest().getQueryString();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Target from request.getRequestURL()=" + (String)object);
        }
        String string = this._config.getString("shire.uri-header", null);
        String string2 = this._config.getString("shire.urlparamkey", null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("shire.uriHeader:" + string);
            LOGGER.debug("shire.urlparamkey:" + string2);
        }
        if (string != null && this.getRequest().getHeader(string) != null) {
            object = this.getRequest().getHeader(string);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found target from header - " + string + ": " + (String)object);
            }
        } else if (string2 != null && this.getParamValueFromQueryString(string2, this.getRequest().getQueryString()) != null) {
            object = this.getParamValueFromQueryString(string2, this.getRequest().getQueryString());
            String string3 = this.stripQueryStringParam(string2, this.getRequest().getQueryString());
            List list = this.getConfig().getList("shire.stripparams.key");
            if (list != null && !list.isEmpty()) {
                for (String string4 : list) {
                    string3 = this.stripQueryStringParam(string4, string3);
                }
            }
            if (string3.startsWith("&")) {
                string3 = string3.replaceFirst("&", "");
            }
            if (string3 != null && string3.length() > 0) {
                object = (String)object + "?" + string3;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found target from parameter " + string2 + "=" + (String)object);
            }
        }
        return object;
    }

    private String getParamValueFromQueryString(String string, String string2) {
        if (string2 != null) {
            String[] stringArray = string2.split("&");
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (!string3.startsWith(string + "=")) continue;
                return string3.split("=")[1];
            }
        }
        return null;
    }

    private String stripQueryStringParam(String string, String string2) {
        Object object = "";
        String string3 = "";
        String[] stringArray = string2.split("&");
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4.startsWith(string + "=")) continue;
            object = (String)object + string3 + string4;
            string3 = "&";
        }
        return object;
    }

    public final Configuration getConfig() {
        return this._config;
    }

    public final void setConfig(Configuration configuration) {
        this._config = configuration;
    }

    public final HttpServletRequest getRequest() {
        return this._request;
    }

    public final void setRequest(HttpServletRequest httpServletRequest) {
        this._request = httpServletRequest;
    }
}

