/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.sso.client.oauth;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.server.OAuthServlet;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.sso.client.SSOClientFilter;
import uk.ac.warwick.sso.client.SSOConfigLoader;
import uk.ac.warwick.sso.client.SSOConfiguration;
import uk.ac.warwick.sso.client.oauth.OAuthService;
import uk.ac.warwick.sso.client.oauth.OAuthServiceImpl;
import uk.ac.warwick.sso.client.oauth.OAuthToken;
import uk.ac.warwick.sso.client.oauth.uk.ac.warwick.sso.client.oauth.CoreOAuthHandler;
import uk.ac.warwick.sso.client.tags.SSOLinkGenerator;
import uk.ac.warwick.userlookup.User;
import uk.ac.warwick.userlookup.UserLookupFactory;
import uk.ac.warwick.userlookup.UserLookupInterface;

public final class OAuthFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthFilter.class);
    private String _configSuffix = "";
    private SSOConfiguration _config;
    private OAuthService _service;
    private UserLookupInterface _userLookup;
    private boolean _expiredToken401 = true;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        User user = SSOClientFilter.getUserFromRequest(httpServletRequest);
        if (user.isFoundUser()) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        SSOLinkGenerator sSOLinkGenerator = new SSOLinkGenerator();
        sSOLinkGenerator.setConfig((Configuration)this.getConfig());
        sSOLinkGenerator.setRequest(httpServletRequest);
        String string = sSOLinkGenerator.getTarget();
        OAuthMessage oAuthMessage = OAuthServlet.getMessage((HttpServletRequest)httpServletRequest, (String)string);
        if (oAuthMessage != null && oAuthMessage.getToken() != null) {
            try {
                OAuthToken oAuthToken = (OAuthToken)this.getOAuthService().getToken(oAuthMessage.getToken()).get();
                if (oAuthToken != null && oAuthToken.isAuthorised() && !oAuthToken.isExpired() && oAuthToken.getType() == OAuthToken.Type.ACCESS && oAuthToken.getConsumerKey().equals(oAuthMessage.getConsumerKey()) && OAuthFilter.isCorrectScope(oAuthToken, this.getConfig().getString("shire.providerid")) && (user = this.getUserLookup().getUserByUserId(oAuthToken.getUserId())) != null && user.isFoundUser()) {
                    user.setOAuthUser(true);
                    user.setIsLoggedIn(true);
                    httpServletRequest.setAttribute(SSOClientFilter.getUserKey(), (Object)user);
                    filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    return;
                }
            }
            catch (OAuthProblemException oAuthProblemException) {
                OAuthServlet.handleException((HttpServletResponse)httpServletResponse, (Exception)((Object)oAuthProblemException), (String)this.getConfig().getString("shire.providerid"));
            }
            catch (ExecutionException executionException) {
                LOGGER.error("Couldn't retrieve user from OAuth token", (Throwable)executionException);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.error("Couldn't retrieve user from OAuth token", (Throwable)interruptedException);
            }
            if (this._expiredToken401) {
                httpServletResponse.addHeader("WWW-Authenticate", "OAuth realm=\"" + this.getConfig().getString("shire.providerid") + "\"");
                httpServletResponse.setStatus(401);
                return;
            }
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private static boolean isCorrectScope(OAuthToken oAuthToken, String string) throws OAuthProblemException {
        return CoreOAuthHandler.isCorrectScope((OAuthToken)oAuthToken, (String)string);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig.getInitParameter("configsuffix") != null) {
            this._configSuffix = filterConfig.getInitParameter("configsuffix");
        }
        if (this._config == null) {
            ServletContext servletContext = filterConfig.getServletContext();
            this._config = (SSOConfiguration)servletContext.getAttribute("SSO-CONFIG" + this._configSuffix);
            if (this._config == null) {
                LOGGER.warn("Could not find sso config in servlet context attribute SSO-CONFIG" + this._configSuffix + "; attempting to load sso config");
                SSOConfigLoader sSOConfigLoader = new SSOConfigLoader();
                sSOConfigLoader.loadSSOConfig(servletContext);
                this._config = (SSOConfiguration)servletContext.getAttribute("SSO-CONFIG" + this._configSuffix);
            }
            if (this._config == null) {
                LOGGER.warn("Could not find sso config in servlet context attribute SSO-CONFIG" + this._configSuffix);
            } else {
                LOGGER.info("Found sso config");
            }
        }
        if (this._service == null && this._config != null) {
            this._service = new OAuthServiceImpl(this._config);
        }
    }

    public void destroy() {
    }

    public SSOConfiguration getConfig() {
        if (this._config == null) {
            this._config = SSOConfiguration.getConfig();
        }
        return this._config;
    }

    public void setConfig(SSOConfiguration sSOConfiguration) {
        this._config = sSOConfiguration;
    }

    public String getConfigSuffix() {
        return this._configSuffix;
    }

    public void setConfigSuffix(String string) {
        this._configSuffix = string;
    }

    public OAuthService getOAuthService() {
        if (this._service == null) {
            this._service = new OAuthServiceImpl(this.getConfig());
        }
        return this._service;
    }

    public void setOAuthService(OAuthService oAuthService) {
        this._service = oAuthService;
    }

    public UserLookupInterface getUserLookup() {
        if (this._userLookup == null) {
            this._userLookup = UserLookupFactory.getInstance();
        }
        return this._userLookup;
    }

    public void setUserLookup(UserLookupInterface userLookupInterface) {
        this._userLookup = userLookupInterface;
    }

    public void setExpiredToken401(boolean bl) {
        this._expiredToken401 = bl;
    }
}

