/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.sso.client.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import uk.ac.warwick.sso.client.core.Cookie;
import uk.ac.warwick.sso.client.core.HttpRequest;
import uk.ac.warwick.sso.client.core.ServletCookies;
import uk.ac.warwick.util.web.Uri;

public class ServletRequestAdapter
implements HttpRequest {
    private final HttpServletRequest req;
    private Map<String, List<String>> parsedQuery;

    public ServletRequestAdapter(HttpServletRequest httpServletRequest) {
        this.req = httpServletRequest;
    }

    public List<String> getParameter(String string) {
        if (this.req.getParameterMap().containsKey(string)) {
            return Arrays.asList(this.req.getParameterValues(string));
        }
        return Collections.emptyList();
    }

    public Set<String> getParameterNames() {
        return new TreeSet<String>(Collections.list(this.req.getParameterNames()));
    }

    public String getHeader(String string) {
        return this.req.getHeader(string);
    }

    public List<String> getHeaders(String string) {
        return Collections.list(this.req.getHeaders(string));
    }

    public String getRemoteAddr() {
        return this.req.getRemoteAddr();
    }

    public String getRequestURL() {
        return this.req.getRequestURL().toString();
    }

    public String getRequestURI() {
        return this.req.getRequestURI();
    }

    public String getQueryString() {
        return this.req.getQueryString();
    }

    public List<String> getQueryParameter(String string) {
        if (this.parsedQuery == null) {
            this.parsedQuery = this.getQueryString() != null ? Uri.parse((String)("?" + this.getQueryString())).getQueryParameters() : new HashMap<String, List<String>>();
        }
        if (this.parsedQuery.containsKey(string)) {
            return this.parsedQuery.get(string);
        }
        return Collections.emptyList();
    }

    public String getMethod() {
        return this.req.getMethod();
    }

    public List<Cookie> getCookies() {
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        javax.servlet.http.Cookie[] cookieArray = this.req.getCookies();
        if (cookieArray != null) {
            for (javax.servlet.http.Cookie cookie : cookieArray) {
                arrayList.add(ServletCookies.fromServlet(cookie));
            }
        }
        return arrayList;
    }

    public Object getAttribute(String string) {
        return this.req.getAttribute(string);
    }
}

