/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.sso.client.cache.spring;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.support.SqlLobValue;
import org.springframework.jdbc.object.SqlUpdate;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import uk.ac.warwick.sso.client.SSOConfiguration;
import uk.ac.warwick.sso.client.SSOToken;
import uk.ac.warwick.sso.client.cache.InMemoryUserCache;
import uk.ac.warwick.sso.client.cache.UserCache;
import uk.ac.warwick.sso.client.cache.UserCacheItem;

public class DatabaseUserCache
implements UserCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseUserCache.class);
    private final SSOConfiguration config;
    private DataSource _dataSource;
    private int _timeout;
    private String _keyName = "key";
    private boolean _databaseEnabled = true;
    private final UserCache _delegate;

    public DatabaseUserCache(SSOConfiguration sSOConfiguration) {
        this(sSOConfiguration, (UserCache)new InMemoryUserCache(sSOConfiguration));
    }

    public DatabaseUserCache(SSOConfiguration sSOConfiguration, UserCache userCache) {
        this.config = sSOConfiguration;
        this._delegate = userCache;
        this._timeout = sSOConfiguration.getInt("ssoclient.sessioncache.database.timeout.secs");
    }

    public final UserCacheItem get(SSOToken sSOToken) {
        if (!this._databaseEnabled) {
            return this._delegate.get(sSOToken);
        }
        LOGGER.debug("Getting item from database cache " + sSOToken.toString());
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.getDataSource());
        UserCacheItem userCacheItem = null;
        try {
            userCacheItem = (UserCacheItem)jdbcTemplate.queryForObject("select objectdata from objectcache where " + this._keyName + " = ?", (Object[])new String[]{sSOToken.toString()}, new RowMapper(){

                public Object mapRow(ResultSet resultSet, int n) throws SQLException {
                    try {
                        ObjectInputStream objectInputStream = new ObjectInputStream(new DefaultLobHandler().getBlobAsBinaryStream(resultSet, 1));
                        UserCacheItem userCacheItem = (UserCacheItem)objectInputStream.readObject();
                        return userCacheItem;
                    }
                    catch (IOException iOException) {
                        LOGGER.error("Could not get cache item back from database", (Throwable)iOException);
                        return null;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        LOGGER.error("Could not get cache item back from database", (Throwable)classNotFoundException);
                        return null;
                    }
                }
            });
        }
        catch (IncorrectResultSizeDataAccessException incorrectResultSizeDataAccessException) {
            LOGGER.debug("No result found, assume not in cache");
            return null;
        }
        LOGGER.debug("Found item in database cache " + sSOToken.toString());
        if (userCacheItem.getInTime() + (long)(this.getTimeout() * 1000) > new java.util.Date().getTime()) {
            return userCacheItem;
        }
        this.remove(sSOToken);
        return null;
    }

    public final void put(SSOToken sSOToken, UserCacheItem userCacheItem) {
        if (!this._databaseEnabled) {
            this._delegate.put(sSOToken, userCacheItem);
            return;
        }
        LOGGER.debug("Putting item into database cache under key " + sSOToken.toString());
        this.remove(sSOToken);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(userCacheItem);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not write object to stream", iOException);
        }
        SqlUpdate sqlUpdate = new SqlUpdate(this.getDataSource(), "INSERT INTO objectcache (" + this._keyName + ", objectdata,createddate) VALUES (?, ?,?)");
        sqlUpdate.declareParameter(new SqlParameter(this._keyName, 12));
        sqlUpdate.declareParameter(new SqlParameter("objectdata", 2004));
        sqlUpdate.declareParameter(new SqlParameter("createddate", 91));
        sqlUpdate.compile();
        Object[] objectArray = new Object[3];
        objectArray[0] = sSOToken.toString();
        DefaultLobHandler defaultLobHandler = new DefaultLobHandler();
        objectArray[1] = new SqlLobValue(byteArrayOutputStream.toByteArray(), (LobHandler)defaultLobHandler);
        objectArray[2] = new Date(new java.util.Date().getTime());
        try {
            sqlUpdate.update(objectArray);
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
            LOGGER.warn("Insert failed as key (" + sSOToken + ") may already exist");
        }
    }

    public final void remove(SSOToken sSOToken) {
        if (!this._databaseEnabled) {
            this._delegate.remove(sSOToken);
            return;
        }
        LOGGER.debug("Removing item from database cache " + sSOToken.toString());
        SqlUpdate sqlUpdate = new SqlUpdate(this.getDataSource(), "DELETE FROM objectcache WHERE " + this._keyName + " = ?");
        sqlUpdate.declareParameter(new SqlParameter(this._keyName, 12));
        sqlUpdate.compile();
        int n = sqlUpdate.update(new Object[]{sSOToken.toString()});
        if (n == 0) {
            LOGGER.debug("No item found in database to remove under key " + sSOToken.toString());
        } else {
            LOGGER.debug(n + " item(s) found in database and removed under key " + sSOToken.toString());
        }
    }

    public final DataSource getDataSource() {
        return this._dataSource;
    }

    public final void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public final int getTimeout() {
        return this._timeout;
    }

    public final void setTimeout(int n) {
        this._timeout = n;
    }

    public final String getKeyName() {
        return this._keyName;
    }

    public final void setKeyName(String string) {
        this._keyName = string;
    }

    public final boolean isDatabaseEnabled() {
        return this._databaseEnabled;
    }

    public final void setDatabaseEnabled(boolean bl) {
        this._databaseEnabled = bl;
    }
}

