/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.sso.client;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.sso.client.SSOClientFilter;
import uk.ac.warwick.sso.client.SSOConfiguration;
import uk.ac.warwick.sso.client.tags.SSOLoginLinkGenerator;
import uk.ac.warwick.userlookup.GroupService;
import uk.ac.warwick.userlookup.User;
import uk.ac.warwick.userlookup.UserLookupFactory;
import uk.ac.warwick.userlookup.webgroups.GroupServiceException;

public class UserInWebGroupFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserInWebGroupFilter.class);
    private String _group;
    private GroupService _groupService;

    public void destroy() {
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String string = SSOConfiguration.getConfig().getString("shire.location");
        String string2 = SSOConfiguration.getConfig().getString("logout.location");
        URL uRL = this.getTarget(httpServletRequest);
        LOGGER.debug("Target=" + uRL);
        if (uRL.toExternalForm().equals(string) || uRL.toExternalForm().equals(string2)) {
            LOGGER.debug("Letting request through without filtering because it is a shire or logout request");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        User user = SSOClientFilter.getUserFromRequest((HttpServletRequest)servletRequest);
        try {
            if (user.isLoggedIn() && this.getGroupService().isUserInGroup(user.getUserId(), this._group)) {
                LOGGER.debug("User " + user.getUserId() + " is in group " + this._group + " so allowing through filter");
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
        }
        catch (GroupServiceException groupServiceException) {
            LOGGER.warn("Error looking up group, continuing assuming user is not in group.", (Throwable)groupServiceException);
        }
        LOGGER.info("User " + user.getUserId() + " is NOT in group " + this._group + " so NOT allowing through filter");
        SSOLoginLinkGenerator sSOLoginLinkGenerator = new SSOLoginLinkGenerator();
        sSOLoginLinkGenerator.setRequest((HttpServletRequest)servletRequest);
        String string3 = sSOLoginLinkGenerator.getPermissionDeniedLink();
        ((HttpServletResponse)servletResponse).sendRedirect(string3);
    }

    public final void init(FilterConfig filterConfig) throws ServletException {
        if (StringUtils.isEmpty((String)this._group)) {
            this._group = filterConfig.getInitParameter("group");
        }
    }

    public final GroupService getGroupService() {
        if (this._groupService == null) {
            return UserLookupFactory.getInstance().getGroupService();
        }
        return this._groupService;
    }

    public final void setGroupService(GroupService groupService) {
        this._groupService = groupService;
    }

    public final String getGroup() {
        return this._group;
    }

    public final void setGroup(String string) {
        this._group = string;
    }

    private URL getTarget(HttpServletRequest httpServletRequest) {
        SSOLoginLinkGenerator sSOLoginLinkGenerator = new SSOLoginLinkGenerator();
        sSOLoginLinkGenerator.setRequest(httpServletRequest);
        try {
            return new URL(sSOLoginLinkGenerator.getTarget());
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.warn("Target is an invalid url", (Throwable)malformedURLException);
            return null;
        }
    }
}

