/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.sso.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.sso.client.AttributeAuthorityResponseFetcher;
import uk.ac.warwick.sso.client.AttributeAuthorityResponseFetcherImpl;
import uk.ac.warwick.sso.client.SSOConfiguration;
import uk.ac.warwick.sso.client.SSOException;
import uk.ac.warwick.sso.client.ShireCommand;
import uk.ac.warwick.sso.client.cache.UserCache;
import uk.ac.warwick.sso.client.core.Cookie;
import uk.ac.warwick.sso.client.util.cookies.ServerCookieEncoder;
import uk.ac.warwick.userlookup.User;
import uk.ac.warwick.userlookup.UserLookup;
import uk.ac.warwick.util.cache.Cache;
import uk.ac.warwick.util.cache.Caches;
import uk.ac.warwick.util.core.StringUtils;

public class ShireServlet
extends HttpServlet {
    private static final long serialVersionUID = 3043814958673574588L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ShireServlet.class);
    private SSOConfiguration _config;
    private UserCache _cache;
    private String _configSuffix = "";
    private Cache<String, User> _userIdCache;
    private String getMessage = null;
    private ServerCookieEncoder serverCookieEncoder = new ServerCookieEncoder(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Closeable closeable;
        httpServletResponse.setStatus(405);
        if (this.getMessage == null) {
            closeable = ((Object)((Object)this)).getClass().getResourceAsStream("/shireget.html");
            this.getMessage = StringUtils.copyToString((Reader)new InputStreamReader((InputStream)closeable));
        }
        httpServletResponse.setContentType("text/html");
        closeable = httpServletResponse.getWriter();
        try {
            ((Writer)closeable).write(this.getMessage);
        }
        finally {
            try {
                ((Writer)closeable).close();
            }
            catch (IOException iOException) {}
        }
    }

    protected final void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.process(httpServletRequest, httpServletResponse);
    }

    public ShireCommand createShireCommand(String string) {
        ShireCommand shireCommand = new ShireCommand(this._userIdCache);
        shireCommand.setRemoteHost(string);
        shireCommand.setCache(this._cache);
        AttributeAuthorityResponseFetcherImpl attributeAuthorityResponseFetcherImpl = new AttributeAuthorityResponseFetcherImpl(this._config);
        shireCommand.setAaFetcher((AttributeAuthorityResponseFetcher)attributeAuthorityResponseFetcherImpl);
        shireCommand.setConfig((Configuration)this._config);
        return shireCommand;
    }

    private void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = httpServletRequest.getParameter("SAMLResponse");
        String string2 = httpServletRequest.getParameter("TARGET");
        String string3 = httpServletRequest.getRemoteHost();
        if (httpServletRequest.getHeader("x-forwarded-for") != null) {
            string3 = httpServletRequest.getHeader("x-forwarded-for");
        }
        ShireCommand shireCommand = this.createShireCommand(string3);
        Cookie cookie = null;
        try {
            cookie = shireCommand.process(string, string2, httpServletRequest.getHeader("User-Agent"));
        }
        catch (SSOException sSOException) {
            LOGGER.warn("Could not generate cookie", (Throwable)sSOException);
        }
        if (cookie != null) {
            LOGGER.debug("Adding SSC (" + cookie.getValue() + " ) to response");
            httpServletResponse.addHeader("Set-Cookie", this.serverCookieEncoder.encode(cookie));
            LOGGER.debug("User being redirected to target with new SSC");
        } else if (this.getCookie(httpServletRequest.getCookies(), this._config.getString("shire.sscookie.name")) == null) {
            LOGGER.warn("No SSC cookie returned to client, nor do they have a previous SSC");
            javax.servlet.http.Cookie cookie2 = new javax.servlet.http.Cookie("SSO-LTC", "");
            cookie2.setDomain(".warwick.ac.uk");
            cookie2.setPath("/");
            cookie2.setMaxAge(0);
            cookie2.setHttpOnly(true);
            httpServletResponse.addCookie(cookie2);
            LOGGER.debug("User being redirected to target but they didn't get a new SSC so we are clearing the SSO-LTC");
        } else {
            LOGGER.debug("User being redirected to target but they didn't get a new SSC, so we are reusing the old one");
        }
        httpServletResponse.setHeader("P3P", "CP=\"CAO PSA OUR\"");
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        httpServletResponse.setHeader("Location", string2);
        httpServletResponse.setStatus(302);
    }

    public final void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (servletConfig.getInitParameter("configsuffix") != null) {
            this._configSuffix = servletConfig.getInitParameter("configsuffix");
        }
        if (this.getConfig() == null) {
            this._config = (SSOConfiguration)servletConfig.getServletContext().getAttribute("SSO-CONFIG" + this._configSuffix);
        }
        if (this.getCache() == null) {
            this._cache = (UserCache)servletConfig.getServletContext().getAttribute("SSO-CACHE" + this._configSuffix);
        }
        if (this.getUserIdCache() == null) {
            this._userIdCache = Caches.builder((String)"UserLookupCache", (Caches.CacheStrategy)Caches.CacheStrategy.valueOf((String)UserLookup.getConfigProperty((String)"ssoclient.cache.strategy"))).properties(UserLookup.getCacheProperties()).maximumSize(10000L).build();
        }
    }

    private javax.servlet.http.Cookie getCookie(javax.servlet.http.Cookie[] cookieArray, String string) {
        if (cookieArray != null) {
            for (javax.servlet.http.Cookie cookie : cookieArray) {
                if (!cookie.getName().equals(string)) continue;
                return cookie;
            }
        }
        return null;
    }

    public final UserCache getCache() {
        return this._cache;
    }

    public final void setCache(UserCache userCache) {
        this._cache = userCache;
    }

    public final SSOConfiguration getConfig() {
        return this._config;
    }

    public final void setConfig(SSOConfiguration sSOConfiguration) {
        this._config = sSOConfiguration;
    }

    public final String getConfigSuffix() {
        return this._configSuffix;
    }

    public final void setConfigSuffix(String string) {
        this._configSuffix = string;
    }

    public final Cache<String, User> getUserIdCache() {
        return this._userIdCache;
    }

    public final void setUserIdCache(Cache<String, User> cache) {
        this._userIdCache = cache;
    }
}

