/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.sso.client;

import java.net.URL;
import java.util.Enumeration;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.sql.DataSource;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.sso.client.SSOConfiguration;
import uk.ac.warwick.sso.client.cache.InMemoryUserCache;
import uk.ac.warwick.sso.client.cache.UserCache;
import uk.ac.warwick.sso.client.cache.spring.DatabaseUserCache;

public class SSOConfigLoader
implements ServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSOConfigLoader.class);
    public static final String SSO_CONFIG_KEY = "SSO-CONFIG";
    public static final String SSO_CACHE_KEY = "SSO-CACHE";

    public final void contextInitialized(ServletContextEvent servletContextEvent) {
        this.loadSSOConfig(servletContextEvent.getServletContext());
    }

    public SSOConfiguration loadSSOConfig(String string) {
        XMLConfiguration xMLConfiguration;
        if (string == null) {
            String string2 = "Path to SSO config was null";
            LOGGER.error(string2);
            throw new RuntimeException(string2);
        }
        URL uRL = SSOConfigLoader.class.getResource(string);
        if (uRL == null) {
            String string3 = "Could not find SSO config at location " + string + " - check your classpath";
            LOGGER.error(string3);
            throw new RuntimeException(string3);
        }
        try {
            xMLConfiguration = new XMLConfiguration(uRL);
        }
        catch (ConfigurationException configurationException) {
            throw new RuntimeException("Could not setup configuration", configurationException);
        }
        SSOConfiguration sSOConfiguration = new SSOConfiguration((Configuration)xMLConfiguration);
        this.sanityCheck((Configuration)sSOConfiguration);
        sSOConfiguration.getAuthenticationDetails();
        return sSOConfiguration;
    }

    private void sanityCheck(Configuration configuration) {
        String string = configuration.getString("mode");
        String string2 = configuration.getString("origin.login.location");
        if ("new".equals(string) && string2.contains("/slogin")) {
            LOGGER.error("It looks like you are using new mode with /slogin in the configuration. New mode should point to /hs");
        } else if ("old".equals(string) && string2.contains("/hs")) {
            LOGGER.error("It looks like you are using old mode with /hs in the configuration. Old mode should point to /slogin");
        }
    }

    public void loadSSOConfig(ServletContext servletContext) {
        Enumeration enumeration = servletContext.getInitParameterNames();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("ssoclient.config")) continue;
            bl = true;
            String string2 = servletContext.getInitParameter(string);
            SSOConfiguration sSOConfiguration = this.loadSSOConfig(string2);
            String string3 = string.replaceFirst("ssoclient.config", "");
            LOGGER.info("Using suffix for config:" + string3);
            this.storeConfig(servletContext, string3, sSOConfiguration);
        }
        if (!bl) {
            throw new IllegalStateException("SSOConfigLoader found no ssoclient.config* element in the web.xml");
        }
    }

    public void storeConfig(ServletContext servletContext, String string, SSOConfiguration sSOConfiguration) {
        servletContext.setAttribute(SSO_CONFIG_KEY + string, (Object)sSOConfiguration);
        UserCache userCache = this.getCache(sSOConfiguration);
        servletContext.setAttribute(SSO_CACHE_KEY + string, (Object)userCache);
    }

    private UserCache getCache(SSOConfiguration sSOConfiguration) {
        if (sSOConfiguration.containsKey("cluster.enabled") && sSOConfiguration.getBoolean("cluster.enabled")) {
            String string = sSOConfiguration.getString("cluster.datasource");
            String string2 = sSOConfiguration.getString("cluster.keyname", "key");
            return this.getClusteredCache(string, string2, sSOConfiguration);
        }
        LOGGER.info("Loading standard InMemoryUserCache");
        return new InMemoryUserCache(sSOConfiguration);
    }

    private UserCache getClusteredCache(String string, String string2, SSOConfiguration sSOConfiguration) {
        LOGGER.info("Loading clustered DatabaseUserCache");
        DatabaseUserCache databaseUserCache = new DatabaseUserCache(sSOConfiguration);
        if (StringUtils.isNotEmpty((String)string2)) {
            databaseUserCache.setKeyName(string2);
        }
        databaseUserCache.setDataSource(this.getDataSource(string));
        return databaseUserCache;
    }

    private DataSource getDataSource(String string) {
        DataSource dataSource = null;
        try {
            InitialContext initialContext = new InitialContext();
            dataSource = (DataSource)initialContext.lookup(string);
        }
        catch (NoInitialContextException noInitialContextException) {
            LOGGER.warn("No InitialContext found, probably not running in a container, so ignoring");
        }
        catch (NamingException namingException) {
            throw new RuntimeException("Could not find datasource for clustered db cache under key " + string, namingException);
        }
        return dataSource;
    }

    public final void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

