/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.sso.client;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.sso.client.AttributeAuthorityResponseFetcher;
import uk.ac.warwick.sso.client.HandleFilter;
import uk.ac.warwick.sso.client.SSOClientHandler;
import uk.ac.warwick.sso.client.SSOClientHandlerImpl;
import uk.ac.warwick.sso.client.SSOConfigLoader;
import uk.ac.warwick.sso.client.SSOConfiguration;
import uk.ac.warwick.sso.client.SSOHandler;
import uk.ac.warwick.sso.client.cache.UserCache;
import uk.ac.warwick.sso.client.core.OnCampusService;
import uk.ac.warwick.userlookup.AnonymousUser;
import uk.ac.warwick.userlookup.User;
import uk.ac.warwick.userlookup.UserLookupFactory;
import uk.ac.warwick.userlookup.UserLookupInterface;

public final class SSOClientFilter
extends HandleFilter
implements Filter {
    private static final int BASIC_AUTH_CACHE_TIME_SECONDS = 300;
    private static final String WARWICK_SSO = "WarwickSSO";
    public static final String USER_KEY = "SSO_USER";
    public static final String ACTUAL_USER_KEY = "SSO_ACTUAL_USER";
    public static final String GLOBAL_LOGIN_COOKIE_NAME = "SSO-LTC";
    public static final String PROXY_TICKET_COOKIE_NAME = "SSO-Proxy";
    private static final Logger LOGGER = LoggerFactory.getLogger(SSOClientFilter.class);
    private SSOClientHandler handler;
    private SSOConfiguration _config;
    private String _configLocation;
    private String _configSuffix = "";
    private UserLookupInterface _userLookup;
    private boolean detectAnonymousOnCampusUsers;
    private boolean redirectToRefreshSession = true;
    private AttributeAuthorityResponseFetcher _aaFetcher;

    public void init(FilterConfig filterConfig) throws ServletException {
        Object object;
        ServletContext servletContext;
        if (filterConfig.getInitParameter("configsuffix") != null) {
            this.setConfigSuffix(filterConfig.getInitParameter("configsuffix"));
        }
        if (this._config == null) {
            servletContext = filterConfig.getServletContext();
            this._config = (SSOConfiguration)servletContext.getAttribute("SSO-CONFIG" + this._configSuffix);
            if (this._config == null) {
                LOGGER.warn("Could not find sso config in servlet context attribute SSO-CONFIG" + this._configSuffix + "; attempting to load sso config");
                object = new SSOConfigLoader();
                if (this._configLocation != null) {
                    LOGGER.info("Loading from location " + this._configLocation);
                    this._config = ((SSOConfigLoader)object).loadSSOConfig(this._configLocation);
                    ((SSOConfigLoader)object).storeConfig(servletContext, this._configSuffix, this._config);
                } else {
                    ((SSOConfigLoader)object).loadSSOConfig(servletContext);
                    this._config = (SSOConfiguration)servletContext.getAttribute("SSO-CONFIG" + this._configSuffix);
                }
            }
            if (this._config == null) {
                LOGGER.warn("Could not find sso config in servlet context attribute SSO-CONFIG" + this._configSuffix);
            } else {
                LOGGER.info("Found sso config");
            }
        }
        if (this.handler == null) {
            servletContext = filterConfig.getServletContext();
            object = (UserCache)servletContext.getAttribute("SSO-CACHE" + this._configSuffix);
            OnCampusService onCampusService = this.getUserLookup().getOnCampusService();
            this.handler = new SSOClientHandlerImpl(this._config, this.getUserLookup(), (UserCache)object, onCampusService);
            this.handler.setDetectAnonymousOnCampusUsers(this.detectAnonymousOnCampusUsers);
            this.handler.setRedirectToRefreshSession(this.redirectToRefreshSession);
            if (this._aaFetcher != null) {
                this.handler.setAaFetcher(this._aaFetcher);
            }
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.filterWithHandler((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
    }

    public static User getUserFromRequest(HttpServletRequest httpServletRequest) {
        String string = SSOClientFilter.getUserKey();
        User user = (User)httpServletRequest.getAttribute(string);
        if (user == null) {
            LOGGER.warn("No user, not even an AnonymousUser found in the request, so returning a new AnonymousUser");
            user = new AnonymousUser();
        }
        return user;
    }

    public static String getUserKey() {
        String string = USER_KEY;
        if (SSOConfiguration.getConfig() != null) {
            string = SSOClientFilter.getUserKey(SSOConfiguration.getConfig());
        } else {
            LOGGER.warn("No SSOConfiguration object found, this request probably didn't go through the SSOClientFilter");
        }
        return string;
    }

    private static String getUserKey(SSOConfiguration sSOConfiguration) {
        return sSOConfiguration.getString("shire.filteruserkey", USER_KEY);
    }

    private static String getActualUserKey(SSOConfiguration sSOConfiguration) {
        return sSOConfiguration.getString("shire.filteractualuserkey", ACTUAL_USER_KEY);
    }

    @Override
    public SSOConfiguration getConfig() {
        return this._config;
    }

    @Override
    public SSOHandler getHandler() {
        return this.handler;
    }

    public void destroy() {
    }

    public void setDetectAnonymousOnCampusUsers(boolean bl) {
        this.detectAnonymousOnCampusUsers = bl;
    }

    public void setConfigSuffix(String string) {
        this._configSuffix = string;
    }

    public void setHandler(SSOClientHandler sSOClientHandler) {
        this.handler = sSOClientHandler;
    }

    public void setUserLookup(UserLookupInterface userLookupInterface) {
        this._userLookup = userLookupInterface;
    }

    public AttributeAuthorityResponseFetcher getAaFetcher() {
        return this.handler.getAaFetcher();
    }

    public String getConfigSuffix() {
        return this._configSuffix;
    }

    public UserLookupInterface getUserLookup() {
        if (this._userLookup == null) {
            this._userLookup = UserLookupFactory.getInstance();
        }
        return this._userLookup;
    }

    public void setRedirectToRefreshSession(boolean bl) {
        this.redirectToRefreshSession = bl;
    }

    public void setConfigLocation(String string) {
        this._configLocation = string;
    }

    public void setAaFetcher(AttributeAuthorityResponseFetcher attributeAuthorityResponseFetcher) {
        this._aaFetcher = attributeAuthorityResponseFetcher;
    }

    public void setConfig(SSOConfiguration sSOConfiguration) {
        this._config = sSOConfiguration;
    }
}

