/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.sso.client;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.sso.client.SSOToken;
import uk.ac.warwick.sso.client.cache.UserCache;

public class LogoutServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogoutServlet.class);
    private UserCache _cache;
    private String _configSuffix = "";

    protected final void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    private void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        String string = httpServletRequest.getParameter("logoutTicket");
        if (string == null || string.equals("")) {
            printWriter.println("false");
            LOGGER.info("Logout attempt failed because no ssc was passed in");
            return;
        }
        SSOToken sSOToken = new SSOToken(string, "urn:websignon:ssc");
        if (this.getCache().get(sSOToken) != null) {
            this.getCache().remove(sSOToken);
            printWriter.println("true");
            LOGGER.info("Logout attempt succeeded as ssc (" + sSOToken + ") was found in cache");
            return;
        }
        LOGGER.info("Logout attempt failed because the ssc (" + sSOToken + ") was not found in the user cache");
        printWriter.println("false");
    }

    public final UserCache getCache() {
        return this._cache;
    }

    public final void setCache(UserCache userCache) {
        this._cache = userCache;
    }

    public final void init(ServletConfig servletConfig) throws ServletException {
        if (servletConfig.getInitParameter("configsuffix") != null) {
            this._configSuffix = servletConfig.getInitParameter("configsuffix");
        }
        if (this.getCache() == null) {
            this.setCache((UserCache)servletConfig.getServletContext().getAttribute("SSO-CACHE" + this._configSuffix));
        }
    }

    public final String getConfigSuffix() {
        return this._configSuffix;
    }

    public final void setConfigSuffix(String string) {
        this._configSuffix = string;
    }
}

