/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.sso.client;

import java.io.IOException;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.ac.warwick.sso.client.HeaderSettingHttpServletRequest;
import uk.ac.warwick.sso.client.SSOConfiguration;
import uk.ac.warwick.sso.client.SSOHandler;
import uk.ac.warwick.sso.client.core.Cookie;
import uk.ac.warwick.sso.client.core.HttpRequest;
import uk.ac.warwick.sso.client.core.Response;
import uk.ac.warwick.sso.client.core.ServletCookies;
import uk.ac.warwick.sso.client.core.ServletRequestAdapter;
import uk.ac.warwick.userlookup.User;

public abstract class HandleFilter {
    private static final String USER_KEY = "SSO_USER";
    private static final String ACTUAL_USER_KEY = "SSO_ACTUAL_USER";

    public abstract SSOConfiguration getConfig();

    public abstract SSOHandler getHandler();

    public void filterWithHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        HeaderSettingHttpServletRequest headerSettingHttpServletRequest = new HeaderSettingHttpServletRequest(httpServletRequest);
        ServletRequestAdapter servletRequestAdapter = new ServletRequestAdapter((HttpServletRequest)headerSettingHttpServletRequest);
        Response response = this.getHandler().handle((HttpRequest)servletRequestAdapter);
        for (Cookie cookie : response.getCookies()) {
            httpServletResponse.addCookie(ServletCookies.toServlet(cookie));
        }
        for (Cookie cookie : response.getHeaders()) {
            httpServletResponse.setHeader(cookie.getName(), cookie.getValue());
        }
        if (response.getUser() != null) {
            this.putUserIntoKey(response.getUser(), headerSettingHttpServletRequest, HandleFilter.getUserKey(this.getConfig()));
        }
        if (response.getActualUser() != null) {
            this.putUserIntoKey(response.getActualUser(), headerSettingHttpServletRequest, HandleFilter.getActualUserKey(this.getConfig()));
        }
        if (response.isContinueRequest()) {
            filterChain.doFilter((ServletRequest)headerSettingHttpServletRequest, (ServletResponse)httpServletResponse);
        } else if (response.getRedirect() != null) {
            httpServletResponse.sendRedirect(response.getRedirect());
        } else {
            httpServletResponse.setStatus(response.getStatusCode());
        }
    }

    private void putUserIntoKey(User user, HeaderSettingHttpServletRequest headerSettingHttpServletRequest, String string) {
        headerSettingHttpServletRequest.setAttribute(string, (Object)user);
        headerSettingHttpServletRequest.setRemoteUser(user.getUserId());
        if (!user.getExtraProperties().isEmpty()) {
            for (Map.Entry entry : user.getExtraProperties().entrySet()) {
                String string2 = (String)entry.getKey();
                String string3 = (String)entry.getValue();
                headerSettingHttpServletRequest.setAttribute(string + "_" + string2, (Object)string3);
                headerSettingHttpServletRequest.addHeader(string + "_" + string2, string3);
            }
        }
        headerSettingHttpServletRequest.setAttribute(string + "_usercode", (Object)user.getUserId());
        headerSettingHttpServletRequest.addHeader(string + "_usercode", user.getUserId());
        headerSettingHttpServletRequest.addHeader(string + "_groups", "");
    }

    private static String getUserKey(SSOConfiguration sSOConfiguration) {
        return sSOConfiguration.getString("shire.filteruserkey", USER_KEY);
    }

    private static String getActualUserKey(SSOConfiguration sSOConfiguration) {
        return sSOConfiguration.getString("shire.filteractualuserkey", ACTUAL_USER_KEY);
    }
}

