/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.sso.client;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.sso.client.AbstractShireSkippingFilter;
import uk.ac.warwick.sso.client.SSOClientFilter;
import uk.ac.warwick.sso.client.tags.SSOLoginLinkGenerator;
import uk.ac.warwick.userlookup.User;

public class ForceLoginFilter
extends AbstractShireSkippingFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForceLoginFilter.class);

    public final void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public final void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        User user = SSOClientFilter.getUserFromRequest(httpServletRequest);
        if (user == null || !user.isLoggedIn()) {
            if (httpServletRequest.getMethod().equalsIgnoreCase("post")) {
                LOGGER.warn("User is posting but is not logged in, so is going to lose data!");
            }
            SSOLoginLinkGenerator sSOLoginLinkGenerator = new SSOLoginLinkGenerator();
            sSOLoginLinkGenerator.setRequest(httpServletRequest);
            String string = sSOLoginLinkGenerator.getNotLoggedInLink();
            httpServletResponse.sendRedirect(string);
            LOGGER.info("Forcing redirect to login screen:" + string);
            return;
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public final void destroy() {
    }
}

