/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.sso.client;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.logstash.logback.argument.StructuredArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerMapping;
import uk.ac.warwick.sso.client.SSOClientFilter;
import uk.ac.warwick.sso.client.core.Cookie;
import uk.ac.warwick.sso.client.util.cookies.ServerCookieEncoder;
import uk.ac.warwick.userlookup.User;

class CSRFImpl {
    static final String CSRF_HTTP_HEADER = "X-CSRF-Token";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"uk.ac.warwick.SECURITY_REPORTS");
    static final String CSRF_COOKIE_NAME = "__Host-SSO-CSRF";
    static final String CSRF_TOKEN_PROPERTY_NAME = "urn:websignon:csrf";
    static final String CSRF_FORCE_INVALIDATE = "urn:websignon:csrf:invalidate";
    static String CSRF_ERROR = "urn:websignon:csrf:error";
    static String CSRF_ERROR_TOKEN_ABSENT = "urn:websignon:csrf:error:absent";
    static String CSRF_ERROR_TOKEN_MISMATCH = "urn:websignon:csrf:error:mismatch";
    private ServerCookieEncoder encoder = new ServerCookieEncoder(false);
    private boolean reportOnlyMode;

    CSRFImpl() {
    }

    void setReportOnlyMode(boolean bl) {
        this.reportOnlyMode = bl;
    }

    boolean handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        User user = SSOClientFilter.getUserFromRequest(httpServletRequest);
        if (user.isFoundUser() && user.isLoggedIn()) {
            String string;
            String string2 = this.reportOnlyMode ? "reporting" : "rejecting";
            Optional<javax.servlet.http.Cookie> optional = Arrays.stream(this.getRequestCookiesSafe(httpServletRequest)).filter(cookie -> cookie.getName().equals(CSRF_COOKIE_NAME)).findFirst();
            boolean bl = false;
            if (!optional.isPresent() || httpServletRequest.getAttribute(CSRF_FORCE_INVALIDATE) != null) {
                LOGGER.debug(optional.isPresent() ? "Forcing invalidation of token due to CSRF_FORCE_INVALIDATE" : "Couldn't find cookie with name __Host-SSO-CSRF");
                string = UUID.randomUUID().toString();
                this.addCsrfCookie(httpServletRequest, httpServletResponse, string);
                bl = true;
            } else {
                string = optional.get().getValue();
            }
            httpServletRequest.setAttribute(CSRF_TOKEN_PROPERTY_NAME, (Object)string);
            if (httpServletRequest.getMethod().equalsIgnoreCase("post")) {
                String string3;
                if (bl) {
                    LOGGER.warn("User didn't have a CSRF token known to the system, and they immediately POST'd.");
                }
                if ((string3 = httpServletRequest.getParameterMap().containsKey(CSRF_TOKEN_PROPERTY_NAME) ? httpServletRequest.getParameter(CSRF_TOKEN_PROPERTY_NAME) : httpServletRequest.getHeader(CSRF_HTTP_HEADER)) == null || string3.length() == 0) {
                    this.logWithRequest(httpServletRequest, httpServletResponse, String.format("No CSRF token was provided in the POST; %s POST request to %s", string2, httpServletRequest.getRequestURL()), string, string3, user);
                    httpServletResponse.setHeader("X-Error", "No CSRF token");
                    if (!this.reportOnlyMode) {
                        httpServletRequest.setAttribute(CSRF_ERROR, (Object)CSRF_ERROR_TOKEN_ABSENT);
                        httpServletResponse.sendError(400);
                        return false;
                    }
                } else if (!MessageDigest.isEqual(string3.getBytes(StandardCharsets.UTF_8), string.getBytes(StandardCharsets.UTF_8))) {
                    this.logWithRequest(httpServletRequest, httpServletResponse, String.format("Provided CSRF token does not match stored CSRF token; %s POST request to %s", string2, httpServletRequest.getRequestURL()), string, string3, user);
                    httpServletResponse.setHeader("X-Error", "Wrong CSRF token");
                    if (!this.reportOnlyMode) {
                        httpServletRequest.setAttribute(CSRF_ERROR, (Object)CSRF_ERROR_TOKEN_MISMATCH);
                        httpServletResponse.sendError(400);
                        return false;
                    }
                } else {
                    LOGGER.debug("Allowing CSRF request through as token matches");
                }
            }
        }
        return true;
    }

    private javax.servlet.http.Cookie[] getRequestCookiesSafe(HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getCookies() == null) {
            return new javax.servlet.http.Cookie[0];
        }
        return httpServletRequest.getCookies();
    }

    private void addCsrfCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        Cookie cookie = new Cookie(CSRF_COOKIE_NAME, string);
        cookie.setHttpOnly(true);
        cookie.setMaxAge(-1);
        cookie.setPath("/");
        cookie.setSecure(true);
        httpServletResponse.addHeader("Set-Cookie", this.encoder.encode(cookie));
    }

    private void logWithRequest(final HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, final String string, final String string2, final String string3, User user) {
        final String string4 = UUID.randomUUID().toString();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_headers", new HashMap<String, Object>(){
            {
                this.put("user-agent", Optional.ofNullable(httpServletRequest.getHeader("User-Agent")).orElse("-"));
                this.put("x-requested-with", Optional.ofNullable(httpServletRequest.getHeader("X-Requested-With")).orElse("-"));
                this.put("referer", Optional.ofNullable(httpServletRequest.getHeader("Referer")).orElse("-"));
            }
        });
        hashMap.put("csrf-report", new HashMap<String, Object>(){
            {
                this.put("document-uri", httpServletRequest.getRequestURL());
                Optional.ofNullable(httpServletRequest.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE)).ifPresent(object -> this.put("best-matching-pattern", object));
                this.put("method", httpServletRequest.getMethod());
                this.put("expected-token", string2);
                this.put("actual-token", string3 == null ? "-" : string3);
                this.put("error", string);
                this.put("correlation-id", string4);
            }
        });
        hashMap.put("username", user.getUserId());
        LOGGER.warn("{}", (Object)StructuredArguments.entries(hashMap));
        httpServletResponse.setHeader("X-Correlation-ID", string4);
    }
}

