/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.sso.client;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.sso.client.SSOConfiguration;
import uk.ac.warwick.sso.client.tags.SSOLoginLinkGenerator;

abstract class AbstractShireSkippingFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractShireSkippingFilter.class);

    AbstractShireSkippingFilter() {
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        SSOConfiguration sSOConfiguration = SSOConfiguration.getConfig();
        String string = sSOConfiguration.getString("shire.location");
        String string2 = sSOConfiguration.getString("logout.location");
        URL uRL = this.getTarget(httpServletRequest);
        LOGGER.debug("Target=" + uRL);
        if (uRL != null && (uRL.toExternalForm().equals(string) || uRL.toExternalForm().equals(string2))) {
            LOGGER.debug("Letting request through without filtering because it is a shire or logout request");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        this.doFilterInternal(httpServletRequest, httpServletResponse, filterChain);
    }

    abstract void doFilterInternal(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws IOException, ServletException;

    private URL getTarget(HttpServletRequest httpServletRequest) {
        SSOLoginLinkGenerator sSOLoginLinkGenerator = new SSOLoginLinkGenerator();
        sSOLoginLinkGenerator.setRequest(httpServletRequest);
        try {
            return new URL(sSOLoginLinkGenerator.getTarget());
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.warn("Target is an invalid url", (Throwable)malformedURLException);
            return null;
        }
    }
}

