package uk.ac.warwick.sso.client;

import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CSRFInterceptor implements HandlerInterceptor {
    public static final String CSRF_HTTP_HEADER = CSRFImpl.CSRF_HTTP_HEADER;

    // DO NOT remove this cookie prefix
    public static final String CSRF_COOKIE_NAME = CSRFImpl.CSRF_COOKIE_NAME;

    public static final String CSRF_TOKEN_PROPERTY_NAME = CSRFImpl.CSRF_TOKEN_PROPERTY_NAME;

    public static final String CSRF_FORCE_INVALIDATE = CSRFImpl.CSRF_FORCE_INVALIDATE;

    public static String CSRF_ERROR = CSRFImpl.CSRF_ERROR;

    public static String CSRF_ERROR_TOKEN_ABSENT = CSRFImpl.CSRF_ERROR_TOKEN_ABSENT;

    public static String CSRF_ERROR_TOKEN_MISMATCH = CSRFImpl.CSRF_ERROR_TOKEN_MISMATCH;

    private final CSRFImpl csrf;

    public CSRFInterceptor() {
        csrf = new CSRFImpl();
    }

    public void setReportOnlyMode(boolean reportOnlyMode) {
        csrf.setReportOnlyMode(reportOnlyMode);
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return csrf.handle(request, response);
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {

    }
}
