package uk.ac.warwick.sso.client;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class CSRFFilter extends AbstractShireSkippingFilter {
    public static final String CSRF_HTTP_HEADER = CSRFImpl.CSRF_HTTP_HEADER;

    // DO NOT remove this cookie prefix
    public static final String CSRF_COOKIE_NAME = CSRFImpl.CSRF_COOKIE_NAME;

    public static final String CSRF_TOKEN_PROPERTY_NAME = CSRFImpl.CSRF_TOKEN_PROPERTY_NAME;

    public static final String CSRF_FORCE_INVALIDATE = CSRFImpl.CSRF_FORCE_INVALIDATE;

    public static String CSRF_ERROR = CSRFImpl.CSRF_ERROR;

    public static String CSRF_ERROR_TOKEN_ABSENT = CSRFImpl.CSRF_ERROR_TOKEN_ABSENT;

    public static String CSRF_ERROR_TOKEN_MISMATCH = CSRFImpl.CSRF_ERROR_TOKEN_MISMATCH;

    private final CSRFImpl csrf;

    public CSRFFilter() {
        csrf = new CSRFImpl();
    }

    public void setReportOnlyMode(boolean reportOnlyMode) {
        csrf.setReportOnlyMode(reportOnlyMode);
    }

    @Override
    void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean allowed = csrf.handle(request, response);


        if (allowed) {
            chain.doFilter(request, response);
        }
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        // nothing
    }

    @Override
    public void destroy() {
        // nothing
    }
}
