/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.regex;

import java.util.function.Predicate;
import wiremock.com.networknt.schema.InvalidSchemaException;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.regex.RegularExpression;
import wiremock.com.networknt.schema.regex.RegularExpressionFactory;

public class AllowRegularExpressionFactory
implements RegularExpressionFactory {
    private final RegularExpressionFactory delegate;
    private final Predicate<String> allowed;

    public AllowRegularExpressionFactory(RegularExpressionFactory delegate, Predicate<String> allowed) {
        this.delegate = delegate;
        this.allowed = allowed;
    }

    @Override
    public RegularExpression getRegularExpression(String regex) {
        if (this.allowed.test(regex)) {
            return this.delegate.getRegularExpression(regex);
        }
        throw new InvalidSchemaException(((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().message("Regular expression ''{1}'' is not allowed to be used.")).arguments(regex)).build());
    }
}

