/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.google.common.graph;

import java.util.Set;
import wiremock.com.google.common.base.Preconditions;
import wiremock.com.google.common.base.Supplier;
import wiremock.com.google.common.collect.ForwardingSet;
import wiremock.com.google.common.graph.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
final class InvalidatableSet<E>
extends ForwardingSet<E> {
    private final Supplier<Boolean> validator;
    private final Set<E> delegate;
    private final Supplier<String> errorMessage;

    public static final <E> InvalidatableSet<E> of(Set<E> delegate, Supplier<Boolean> validator, Supplier<String> errorMessage) {
        return new InvalidatableSet<E>(Preconditions.checkNotNull(delegate), Preconditions.checkNotNull(validator), Preconditions.checkNotNull(errorMessage));
    }

    @Override
    protected Set<E> delegate() {
        this.validate();
        return this.delegate;
    }

    private InvalidatableSet(Set<E> delegate, Supplier<Boolean> validator, Supplier<String> errorMessage) {
        this.delegate = delegate;
        this.validator = validator;
        this.errorMessage = errorMessage;
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    private void validate() {
        if (!this.validator.get().booleanValue()) {
            throw new IllegalStateException(this.errorMessage.get());
        }
    }
}

