/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.matching.ContentPatternDeserialiser;
import com.github.tomakehurst.wiremock.matching.NamedValueMatcher;
import java.util.Objects;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;
import wiremock.com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonDeserialize(using=ContentPatternDeserialiser.class)
public abstract class ContentPattern<T>
implements NamedValueMatcher<T> {
    protected final T expectedValue;

    public ContentPattern(T expectedValue) {
        if (!this.isNullValuePermitted()) {
            ParameterUtils.checkNotNull(expectedValue, "'" + this.getName() + "' expected value cannot be null");
        }
        this.expectedValue = expectedValue;
    }

    @JsonIgnore
    public T getValue() {
        return this.expectedValue;
    }

    protected boolean isNullValuePermitted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentPattern that = (ContentPattern)o;
        return Objects.equals(this.expectedValue, that.expectedValue);
    }

    public int hashCode() {
        return this.expectedValue != null ? this.expectedValue.hashCode() : 0;
    }
}

