/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.marketplace;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Recipe;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.DeclarativeRecipe;
import org.openrewrite.config.Environment;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;
import org.openrewrite.marketplace.RecipeMarketplaceWriter;
import org.openrewrite.marketplace.YamlRecipeBundle;
import org.openrewrite.maven.marketplace.RecipeClassLoader;
import org.openrewrite.maven.marketplace.ResolvedMavenRecipeBundle;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

public class MavenRecipeMarketplaceGenerator {
    private final ResolvedGroupArtifactVersion gav;
    private final Path recipeJar;
    private final List<Path> classpath;

    public MavenRecipeMarketplaceGenerator(GroupArtifact ga, Path recipeJar, List<Path> classpath) {
        this.gav = new ResolvedGroupArtifactVersion(null, ga.getGroupId(), ga.getArtifactId(), null, null);
        this.recipeJar = recipeJar;
        this.classpath = classpath;
    }

    public RecipeMarketplace generate() {
        try {
            if (Files.notExists(this.recipeJar, new LinkOption[0])) {
                throw new IllegalArgumentException("Recipe JAR does not exist " + this.recipeJar);
            }
            Environment firstPassEnv = Environment.builder().scanJar(this.recipeJar.toAbsolutePath(), (Collection)this.classpath.stream().map(Path::toAbsolutePath).collect(Collectors.toList()), RecipeClassLoader.forScanning(this.recipeJar, this.classpath)).build();
            List targetRecipeNames = firstPassEnv.listRecipeDescriptors().stream().map(RecipeDescriptor::getName).collect(Collectors.toList());
            ResolvedMavenRecipeBundle bundle = new ResolvedMavenRecipeBundle(this.gav, this.recipeJar, this.classpath, RecipeClassLoader::new, null);
            Environment env = bundle.getEnvironment();
            RecipeMarketplace root = RecipeMarketplace.newEmpty();
            for (RecipeDescriptor descriptor : env.listRecipeDescriptors()) {
                if (!targetRecipeNames.contains(descriptor.getName())) continue;
                RecipeDescriptor bundledDescriptor = descriptor.withBundle(this.createBundle(descriptor, env));
                List<String> categories = this.extractCategories(descriptor.getName(), env);
                root.addRecipe((RecipeListing)bundledDescriptor, categories.toArray(new String[0]));
            }
            return root;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate marketplace for " + this.gav, e);
        }
    }

    private RecipeBundle createBundle(RecipeDescriptor descriptor, Environment env) {
        DeclarativeRecipe declarativeRecipe;
        URI source;
        Recipe recipe = env.activateRecipes(new String[]{descriptor.getName()});
        if (recipe instanceof DeclarativeRecipe && (source = this.getDeclarativeSource(declarativeRecipe = (DeclarativeRecipe)recipe)) != null && this.isYamlSource(source)) {
            return new YamlRecipeBundle(URI.create("maven-rewrite-yaml:" + this.gav.getGroupId() + ":" + this.gav.getArtifactId() + ":!/" + this.extractPathFromJarUri(source.toString())), this.gav.getVersion(), new Properties(), null){

                public String getVersion() {
                    return MavenRecipeMarketplaceGenerator.this.gav.getDatedSnapshotVersion() == null ? MavenRecipeMarketplaceGenerator.this.gav.getVersion() : MavenRecipeMarketplaceGenerator.this.gav.getDatedSnapshotVersion();
                }
            };
        }
        return new ResolvedMavenRecipeBundle(this.gav, this.recipeJar, this.classpath, RecipeClassLoader::new, null);
    }

    private @Nullable URI getDeclarativeSource(DeclarativeRecipe recipe) {
        try {
            Field sourceField = DeclarativeRecipe.class.getDeclaredField("source");
            sourceField.setAccessible(true);
            return (URI)sourceField.get(recipe);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isYamlSource(URI source) {
        String path = source.toString();
        return path.contains("META-INF/rewrite") && (path.endsWith(".yml") || path.endsWith(".yaml"));
    }

    private String extractPathFromJarUri(String uriString) {
        int bangIndex = uriString.indexOf("!");
        if (bangIndex != -1) {
            return uriString.substring(bangIndex + 2);
        }
        int metaInfIndex = uriString.indexOf("META-INF/rewrite");
        if (metaInfIndex != -1) {
            return uriString.substring(metaInfIndex);
        }
        return uriString;
    }

    private List<String> extractCategories(String recipeName, Environment env) {
        int lastDot = recipeName.lastIndexOf(46);
        if (lastDot == -1) {
            return Collections.emptyList();
        }
        String packageName = recipeName.substring(0, lastDot);
        String[] parts = packageName.split("\\.");
        ArrayList<String> categories = new ArrayList<String>(parts.length);
        block0: for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            String partialPackage = String.join((CharSequence)".", Arrays.copyOfRange(parts, 0, i + 1));
            for (CategoryDescriptor categoryDescriptor : env.listCategoryDescriptors()) {
                String categoryPackageName = categoryDescriptor.getPackageName();
                if (!categoryPackageName.equals(partialPackage)) continue;
                if (categoryDescriptor.isRoot()) continue block0;
                categories.add(categoryDescriptor.getDisplayName());
                continue block0;
            }
            if (part.isEmpty()) continue;
            String capitalized = Character.toUpperCase(part.charAt(0)) + part.substring(1);
            categories.add(capitalized);
        }
        return categories;
    }

    public static void main(String[] args) throws IOException {
        String[] gav;
        if (args.length < 3) {
            System.err.println("Usage: java MavenRecipeMarketplaceGenerator <groupId:artifactId> <output-csv-path> <recipe-jar> [classpath-entries...]");
            System.exit(1);
        }
        if ((gav = args[0].split(":")).length != 2) {
            System.err.println("Invalid groupId:artifactId format: " + args[0]);
            System.exit(1);
        }
        String groupId = gav[0];
        String artifactId = gav[1];
        Path outputCsv = Paths.get(args[1], new String[0]);
        Path recipeJar = Paths.get(args[2], new String[0]);
        ArrayList<Path> classpath = new ArrayList<Path>();
        for (int i = 3; i < args.length; ++i) {
            classpath.add(Paths.get(args[i], new String[0]));
        }
        GroupArtifact ga = new GroupArtifact(groupId, artifactId);
        RecipeMarketplace marketplace = new MavenRecipeMarketplaceGenerator(ga, recipeJar, classpath).generate();
        String csv = new RecipeMarketplaceWriter().toCsv(marketplace);
        Files.write(outputCsv, csv.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        System.out.println("Generated marketplace CSV with " + marketplace.getAllRecipes().size() + " recipes");
        System.out.println("Output written to: " + outputCsv.toAbsolutePath());
    }
}

