/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openrewrite.maven.graph.DependencyGraph;
import org.openrewrite.maven.graph.DependencyGraphBuilder;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

public abstract class AbstractDependencyGraphBuilder<T extends DependencyGraph.DependencyNode>
implements DependencyGraphBuilder<T> {
    @Override
    public void collectDependencyPaths(List<ResolvedDependency> dependencies, Map<ResolvedGroupArtifactVersion, List<DependencyGraph.DependencyPath>> paths, String scope) {
        for (ResolvedDependency dependency : dependencies) {
            ArrayList<DependencyGraph.DependencyNode> parentPath = new ArrayList<DependencyGraph.DependencyNode>();
            this.collectDependencyPathsRecursive(dependency, parentPath, paths, scope);
        }
    }

    private void collectDependencyPathsRecursive(ResolvedDependency dependency, List<DependencyGraph.DependencyNode> parentPath, Map<ResolvedGroupArtifactVersion, List<DependencyGraph.DependencyPath>> paths, String scope) {
        ResolvedGroupArtifactVersion gav = dependency.getGav();
        ArrayList<DependencyGraph.DependencyNode> pathNodes = new ArrayList<DependencyGraph.DependencyNode>();
        Object node = this.createNode(dependency, scope);
        pathNodes.add((DependencyGraph.DependencyNode)node);
        pathNodes.addAll(parentPath);
        DependencyGraph.DependencyPath path = new DependencyGraph.DependencyPath(pathNodes, scope);
        paths.computeIfAbsent(gav, k -> new ArrayList()).add(path);
        ArrayList<DependencyGraph.DependencyNode> newParentPath = new ArrayList<DependencyGraph.DependencyNode>();
        newParentPath.add((DependencyGraph.DependencyNode)node);
        newParentPath.addAll(parentPath);
        for (ResolvedDependency child : dependency.getDependencies()) {
            if (!newParentPath.stream().noneMatch(childPath -> childPath.getGroupId().equals(child.getGroupId()) && childPath.getArtifactId().equals(child.getArtifactId()))) continue;
            this.collectDependencyPathsRecursive(child, newParentPath, paths, scope);
        }
    }
}

