/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public class FindMavenProject
extends Recipe {
    public String getDisplayName() {
        return "Find Maven projects";
    }

    public String getDescription() {
        return "Maven projects are `pom.xml` files with a `MavenResolutionResult` marker.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new XmlIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                if (document.getMarkers().findFirst(MavenResolutionResult.class).isPresent()) {
                    return (Xml.Document)SearchResult.found((Tree)document);
                }
                return super.visitDocument(document, (Object)ctx);
            }
        };
    }
}

