/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenDownloadingExceptions;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.Parent;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.xml.tree.Xml;

public class UpdateMavenModel<P>
extends MavenVisitor<P> {
    public Xml visitDocument(Xml.Document document, P p) {
        Optional repos;
        Optional parent;
        if (!(p instanceof ExecutionContext)) {
            throw new IllegalArgumentException("UpdateMavenModel must be provided an ExecutionContext");
        }
        ExecutionContext ctx = (ExecutionContext)p;
        MavenResolutionResult resolutionResult = this.getResolutionResult();
        Pom requested = resolutionResult.getPom().getRequested();
        requested.getProperties().clear();
        Optional properties = document.getRoot().getChild("properties");
        if (properties.isPresent()) {
            for (Xml.Tag propertyTag : ((Xml.Tag)properties.get()).getChildren()) {
                requested.getProperties().put(propertyTag.getName(), propertyTag.getValue().orElse(""));
            }
        }
        if (resolutionResult.getUserProperties() != null) {
            requested.getProperties().putAll(resolutionResult.getUserProperties());
        }
        if ((parent = document.getRoot().getChild("parent")).isPresent()) {
            Parent updatedParent = new Parent(new GroupArtifactVersion(((Xml.Tag)parent.get()).getChildValue("groupId").orElse(null), (String)((Xml.Tag)parent.get()).getChildValue("artifactId").orElseThrow(() -> new IllegalStateException("GAV must have artifactId")), ((Xml.Tag)parent.get()).getChildValue("version").orElse(null)), ((Xml.Tag)parent.get()).getChildValue("relativePath").orElse(null));
            requested = requested.withParent(updatedParent);
        } else if (requested.getParent() != null) {
            requested = requested.withParent(null);
        }
        Optional dependencies = document.getRoot().getChild("dependencies");
        if (dependencies.isPresent()) {
            List eachDependency = ((Xml.Tag)dependencies.get()).getChildren("dependency");
            ArrayList<Dependency> requestedDependencies = new ArrayList<Dependency>(eachDependency.size());
            for (Xml.Tag dependency : eachDependency) {
                requestedDependencies.add(Dependency.builder().gav(new GroupArtifactVersion(dependency.getChildValue("groupId").orElse(null), (String)dependency.getChildValue("artifactId").orElseThrow(() -> new IllegalStateException("Dependency must have artifactId")), dependency.getChildValue("version").orElse(null))).classifier(dependency.getChildValue("classifier").orElse(null)).type(dependency.getChildValue("type").orElse(null)).scope(dependency.getChildValue("scope").orElse("compile")).exclusions(this.mapExclusions(dependency)).optional(dependency.getChildValue("optional").orElse(null)).build());
            }
            requested = requested.withDependencies(requestedDependencies);
        } else if (!requested.getDependencies().isEmpty()) {
            requested = requested.withDependencies(Collections.emptyList());
        }
        Optional dependencyManagement = document.getRoot().getChild("dependencyManagement");
        if (dependencyManagement.isPresent()) {
            dependencies = ((Xml.Tag)dependencyManagement.get()).getChild("dependencies");
            if (dependencies.isPresent()) {
                List eachDependency = ((Xml.Tag)dependencies.get()).getChildren("dependency");
                ArrayList<ManagedDependency> requestedManagedDependencies = new ArrayList<ManagedDependency>(eachDependency.size());
                for (Xml.Tag dependency : eachDependency) {
                    String scope = dependency.getChildValue("scope").orElse(null);
                    GroupArtifactVersion gav = new GroupArtifactVersion(dependency.getChildValue("groupId").orElse(null), (String)dependency.getChildValue("artifactId").orElseThrow(() -> new IllegalStateException("Dependency must have artifactId")), dependency.getChildValue("version").orElse(null));
                    if ("import".equals(scope)) {
                        requestedManagedDependencies.add(new ManagedDependency.Imported(gav));
                        continue;
                    }
                    requestedManagedDependencies.add(new ManagedDependency.Defined(gav, scope, dependency.getChildValue("type").orElse(null), dependency.getChildValue("classifier").orElse(null), this.mapExclusions(dependency)));
                }
                requested = requested.withDependencyManagement(requestedManagedDependencies);
            }
        } else if (!requested.getDependencyManagement().isEmpty()) {
            requested = requested.withDependencyManagement(Collections.emptyList());
        }
        requested = (repos = document.getRoot().getChild("repositories")).isPresent() ? requested.withRepositories(((Xml.Tag)repos.get()).getChildren("repository").stream().map(t -> new MavenRepository(t.getChildValue("id").orElse(null), (String)t.getChildValue("url").get(), t.getChild("releases").flatMap(s -> s.getChildValue("enabled")).orElse(null), t.getChild("snapshots").flatMap(s -> s.getChildValue("enabled")).orElse(null), null, null, null)).collect(Collectors.toList())) : requested.withRepositories(Collections.emptyList());
        try {
            MavenResolutionResult updated = this.updateResult(ctx, resolutionResult.withPom(resolutionResult.getPom().withRequested(requested)), resolutionResult.getProjectPoms());
            return document.withMarkers(document.getMarkers().computeByType((Marker)this.getResolutionResult(), (original, ignored) -> updated));
        }
        catch (MavenDownloadingExceptions e) {
            return e.warn(document);
        }
    }

    private @Nullable List<GroupArtifact> mapExclusions(Xml.Tag tag) {
        return tag.getChild("exclusions").map(exclusions -> {
            List eachExclusion = exclusions.getChildren("exclusion");
            ArrayList<GroupArtifact> requestedExclusions = new ArrayList<GroupArtifact>(eachExclusion.size());
            for (Xml.Tag exclusion : eachExclusion) {
                requestedExclusions.add(new GroupArtifact(exclusion.getChildValue("groupId").orElse(null), exclusion.getChildValue("artifactId").orElse(null)));
            }
            return requestedExclusions;
        }).orElse(null);
    }

    private MavenResolutionResult updateResult(ExecutionContext ctx, MavenResolutionResult resolutionResult, Map<Path, Pom> projectPoms) throws MavenDownloadingExceptions {
        MavenPomDownloader downloader = new MavenPomDownloader(projectPoms, ctx, this.getResolutionResult().getMavenSettings(), this.getResolutionResult().getActiveProfiles());
        AtomicReference exceptions = new AtomicReference();
        try {
            ResolvedPom resolved = resolutionResult.getPom().resolve(ctx, downloader);
            MavenResolutionResult mrr = resolutionResult.withPom(resolved).withModules(ListUtils.map(resolutionResult.getModules(), module -> {
                try {
                    return this.updateResult(ctx, (MavenResolutionResult)module, projectPoms);
                }
                catch (MavenDownloadingExceptions e) {
                    exceptions.set(MavenDownloadingExceptions.append((MavenDownloadingExceptions)exceptions.get(), e));
                    return module;
                }
            })).resolveDependencies(downloader, ctx);
            if (exceptions.get() != null) {
                throw (MavenDownloadingExceptions)exceptions.get();
            }
            return mrr;
        }
        catch (MavenDownloadingExceptions e) {
            throw MavenDownloadingExceptions.append((MavenDownloadingExceptions)exceptions.get(), e);
        }
        catch (MavenDownloadingException e) {
            throw MavenDownloadingExceptions.append((MavenDownloadingExceptions)exceptions.get(), e);
        }
    }
}

