/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

@Incubating(since="8.12.0")
public class AnnotationService {
    public boolean matches(Cursor cursor, AnnotationMatcher matcher) {
        for (J.Annotation annotation : this.getAllAnnotations(cursor)) {
            if (!matcher.matches(annotation)) continue;
            return true;
        }
        return false;
    }

    public List<J.Annotation> getAllAnnotations(Cursor cursor) {
        J j = (J)cursor.getValue();
        if (j instanceof J.VariableDeclarations) {
            return this.getAllAnnotations((J.VariableDeclarations)j);
        }
        if (j instanceof J.MethodDeclaration) {
            return ((J.MethodDeclaration)j).getAllAnnotations();
        }
        if (j instanceof J.ClassDeclaration) {
            return ((J.ClassDeclaration)j).getAllAnnotations();
        }
        if (j instanceof J.TypeParameter) {
            return ((J.TypeParameter)j).getAnnotations();
        }
        if (j instanceof J.TypeParameters) {
            return ((J.TypeParameters)j).getAnnotations();
        }
        if (j instanceof J.Package) {
            return ((J.Package)j).getAnnotations();
        }
        if (j instanceof J.AnnotatedType) {
            return this.getAllAnnotations((J.AnnotatedType)j);
        }
        if (j instanceof J.ArrayType) {
            return this.getAllAnnotations((J.ArrayType)j);
        }
        if (j instanceof J.FieldAccess) {
            return this.getAllAnnotations((J.FieldAccess)j);
        }
        if (j instanceof J.Identifier) {
            return this.getAllAnnotations((J.Identifier)j);
        }
        return Collections.emptyList();
    }

    private List<J.Annotation> getAllAnnotations(J j) {
        if (j instanceof J.AnnotatedType) {
            return this.getAllAnnotations((J.AnnotatedType)j);
        }
        if (j instanceof J.ArrayType) {
            return this.getAllAnnotations((J.ArrayType)j);
        }
        if (j instanceof J.Identifier) {
            return this.getAllAnnotations((J.Identifier)j);
        }
        if (j instanceof J.FieldAccess) {
            return this.getAllAnnotations((J.FieldAccess)j);
        }
        if (j instanceof J.VariableDeclarations) {
            return this.getAllAnnotations((J.VariableDeclarations)j);
        }
        return Collections.emptyList();
    }

    private List<J.Annotation> getAllAnnotations(J.VariableDeclarations variableDeclarations) {
        ArrayList<J.Annotation> allAnnotations = new ArrayList<J.Annotation>(variableDeclarations.getLeadingAnnotations());
        for (J.Modifier modifier : variableDeclarations.getModifiers()) {
            allAnnotations.addAll(modifier.getAnnotations());
        }
        if (variableDeclarations.getTypeExpression() instanceof J.AnnotatedType) {
            allAnnotations.addAll(this.getAllAnnotations((J.AnnotatedType)variableDeclarations.getTypeExpression()));
        }
        return allAnnotations;
    }

    private List<J.Annotation> getAllAnnotations(J.AnnotatedType annotatedType) {
        List<J.Annotation> targetAnnotations = this.getAllAnnotations(annotatedType.getTypeExpression());
        if (targetAnnotations.isEmpty()) {
            return annotatedType.getAnnotations();
        }
        ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>(annotatedType.getAnnotations().size() + targetAnnotations.size());
        annotations.addAll(annotatedType.getAnnotations());
        annotations.addAll(targetAnnotations);
        return annotations;
    }

    private List<J.Annotation> getAllAnnotations(J.ArrayType arrayType) {
        if (arrayType.getAnnotations() != null) {
            return arrayType.getAnnotations();
        }
        return Collections.emptyList();
    }

    private List<J.Annotation> getAllAnnotations(J.FieldAccess fieldAccess) {
        return this.getAllAnnotations(fieldAccess.getName());
    }

    private List<J.Annotation> getAllAnnotations(J.Identifier identifier) {
        return identifier.getAnnotations();
    }

    public boolean isAnnotatedWith(J j, String annotationFqn) {
        return this.isAnnotatedWith(j, annotationFqn, true);
    }

    public boolean isAnnotatedWith(J j, String annotationFqn, boolean includeMetaAnnotations) {
        return !this.annotatedWith(j, annotationFqn, includeMetaAnnotations).isEmpty();
    }

    public List<JavaType.FullyQualified> annotatedWith(J j, String annotationFqn) {
        return this.annotatedWith(j, annotationFqn, true);
    }

    public List<JavaType.FullyQualified> annotatedWith(J j, String annotationFqn, boolean includeMetaAnnotations) {
        ArrayList<JavaType.FullyQualified> result = new ArrayList<JavaType.FullyQualified>();
        HashSet<String> visited = new HashSet<String>();
        if (j instanceof J.ClassDeclaration) {
            J.ClassDeclaration classDecl = (J.ClassDeclaration)j;
            JavaType.FullyQualified type = TypeUtils.asFullyQualified(classDecl.getType());
            if (type != null) {
                this.collectClassAnnotations(type, annotationFqn, result, visited, includeMetaAnnotations);
            }
        } else if (j instanceof J.MethodDeclaration) {
            J.MethodDeclaration methodDecl = (J.MethodDeclaration)j;
            if (methodDecl.getMethodType() != null) {
                this.collectMethodAnnotations(methodDecl.getMethodType(), annotationFqn, result, visited, includeMetaAnnotations);
            }
        } else if (j instanceof J.VariableDeclarations) {
            J.VariableDeclarations varDecls = (J.VariableDeclarations)j;
            for (J.Annotation ann : this.getAllAnnotations(varDecls)) {
                JavaType.FullyQualified annType = TypeUtils.asFullyQualified(ann.getType());
                if (annType == null) continue;
                this.collectAnnotationAndMeta(annType, annotationFqn, result, visited, includeMetaAnnotations);
            }
        }
        return result;
    }

    private void collectClassAnnotations(JavaType.FullyQualified type, String annotationFqn, List<JavaType.FullyQualified> result, Set<String> visited, boolean includeMetaAnnotations) {
        if (!visited.add(type.getFullyQualifiedName())) {
            return;
        }
        for (JavaType.FullyQualified annotation : type.getAnnotations()) {
            this.collectAnnotationAndMeta(annotation, annotationFqn, result, visited, includeMetaAnnotations);
        }
        @Nullable JavaType.FullyQualified supertype = type.getSupertype();
        if (supertype != null && !(supertype instanceof JavaType.Unknown)) {
            this.collectClassAnnotations(supertype, annotationFqn, result, visited, includeMetaAnnotations);
        }
        for (JavaType.FullyQualified _interface : type.getInterfaces()) {
            if (_interface instanceof JavaType.Unknown) continue;
            this.collectClassAnnotations(_interface, annotationFqn, result, visited, includeMetaAnnotations);
        }
    }

    private void collectMethodAnnotations(JavaType.Method method, String annotationFqn, List<JavaType.FullyQualified> result, Set<String> visited, boolean includeMetaAnnotations) {
        for (JavaType.FullyQualified annotation : method.getAnnotations()) {
            this.collectAnnotationAndMeta(annotation, annotationFqn, result, visited, includeMetaAnnotations);
        }
        JavaType.Method override = method.getOverride();
        if (override != null) {
            this.collectMethodAnnotations(override, annotationFqn, result, visited, includeMetaAnnotations);
        }
    }

    private void collectAnnotationAndMeta(JavaType.FullyQualified annotation, String annotationFqn, List<JavaType.FullyQualified> result, Set<String> visited, boolean includeMetaAnnotations) {
        String annFqn = annotation.getFullyQualifiedName();
        if (visited.contains(annFqn)) {
            return;
        }
        if (TypeUtils.isAssignableTo(annotationFqn, (JavaType)annotation)) {
            result.add(annotation);
        }
        visited.add(annFqn);
        if (includeMetaAnnotations && !annFqn.startsWith("java.lang.annotation.") && !annFqn.startsWith("jdk.internal.")) {
            for (JavaType.FullyQualified metaAnnotation : annotation.getAnnotations()) {
                this.collectAnnotationAndMeta(metaAnnotation, annotationFqn, result, visited, includeMetaAnnotations);
            }
        }
    }
}

