/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class ReplaceConstantWithAnotherConstant
extends Recipe {
    @Option(displayName="Fully qualified name of the constant to replace", example="org.springframework.http.MediaType.APPLICATION_JSON_VALUE")
    private final String existingFullyQualifiedConstantName;
    @Option(displayName="Fully qualified name of the constant to use in place of existing constant", example="org.springframework.http.MediaType.APPLICATION_JSON_VALUE")
    private final String fullyQualifiedConstantName;

    public String getDisplayName() {
        return "Replace constant with another constant";
    }

    public String getDescription() {
        return "Replace a constant with another constant, adding/removing import on class if needed.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesType(this.existingFullyQualifiedConstantName.substring(0, this.existingFullyQualifiedConstantName.lastIndexOf(46)), false), (TreeVisitor)new ReplaceConstantWithAnotherConstantVisitor(this.existingFullyQualifiedConstantName, this.fullyQualifiedConstantName));
    }

    @Generated
    public ReplaceConstantWithAnotherConstant(String existingFullyQualifiedConstantName, String fullyQualifiedConstantName) {
        this.existingFullyQualifiedConstantName = existingFullyQualifiedConstantName;
        this.fullyQualifiedConstantName = fullyQualifiedConstantName;
    }

    @Generated
    public String getExistingFullyQualifiedConstantName() {
        return this.existingFullyQualifiedConstantName;
    }

    @Generated
    public String getFullyQualifiedConstantName() {
        return this.fullyQualifiedConstantName;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ReplaceConstantWithAnotherConstant(existingFullyQualifiedConstantName=" + this.getExistingFullyQualifiedConstantName() + ", fullyQualifiedConstantName=" + this.getFullyQualifiedConstantName() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceConstantWithAnotherConstant)) {
            return false;
        }
        ReplaceConstantWithAnotherConstant other = (ReplaceConstantWithAnotherConstant)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$existingFullyQualifiedConstantName = this.getExistingFullyQualifiedConstantName();
        String other$existingFullyQualifiedConstantName = other.getExistingFullyQualifiedConstantName();
        if (this$existingFullyQualifiedConstantName == null ? other$existingFullyQualifiedConstantName != null : !this$existingFullyQualifiedConstantName.equals(other$existingFullyQualifiedConstantName)) {
            return false;
        }
        String this$fullyQualifiedConstantName = this.getFullyQualifiedConstantName();
        String other$fullyQualifiedConstantName = other.getFullyQualifiedConstantName();
        return !(this$fullyQualifiedConstantName == null ? other$fullyQualifiedConstantName != null : !this$fullyQualifiedConstantName.equals(other$fullyQualifiedConstantName));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ReplaceConstantWithAnotherConstant;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $existingFullyQualifiedConstantName = this.getExistingFullyQualifiedConstantName();
        result = result * 59 + ($existingFullyQualifiedConstantName == null ? 43 : $existingFullyQualifiedConstantName.hashCode());
        String $fullyQualifiedConstantName = this.getFullyQualifiedConstantName();
        result = result * 59 + ($fullyQualifiedConstantName == null ? 43 : $fullyQualifiedConstantName.hashCode());
        return result;
    }

    private static class ReplaceConstantWithAnotherConstantVisitor
    extends JavaVisitor<ExecutionContext> {
        private final String existingOwningType;
        private final String constantName;
        private final JavaType.FullyQualified existingOwningTypeFqn;
        private final JavaType.FullyQualified newOwningType;
        private final JavaType.FullyQualified newTargetType;
        private final String newConstantName;

        public ReplaceConstantWithAnotherConstantVisitor(String existingFullyQualifiedConstantName, String fullyQualifiedConstantName) {
            this.existingOwningType = existingFullyQualifiedConstantName.substring(0, existingFullyQualifiedConstantName.lastIndexOf(46));
            this.constantName = existingFullyQualifiedConstantName.substring(existingFullyQualifiedConstantName.lastIndexOf(46) + 1);
            this.existingOwningTypeFqn = JavaType.ShallowClass.build(this.existingOwningType);
            this.newOwningType = JavaType.ShallowClass.build(fullyQualifiedConstantName.substring(0, fullyQualifiedConstantName.lastIndexOf(46)));
            this.newTargetType = JavaType.ShallowClass.build(fullyQualifiedConstantName);
            this.newConstantName = fullyQualifiedConstantName.substring(fullyQualifiedConstantName.lastIndexOf(46) + 1);
        }

        @Override
        public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            JavaType.Variable fieldType = fieldAccess.getName().getFieldType();
            if (this.isConstant(fieldType)) {
                JavaSourceFile sf = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                return this.replaceFieldAccess(fieldAccess, fieldType, this.hasNoConflictingImport(sf));
            }
            return super.visitFieldAccess(fieldAccess, ctx);
        }

        @Override
        public J visitIdentifier(J.Identifier ident, ExecutionContext ctx) {
            JavaType.Variable fieldType = ident.getFieldType();
            if (this.isConstant(fieldType)) {
                JavaSourceFile sf = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                return this.replaceFieldAccess(ident, fieldType, this.hasNoConflictingImport(sf));
            }
            return super.visitIdentifier(ident, ctx);
        }

        private J replaceFieldAccess(Expression expression, JavaType.Variable fieldType, boolean hasNoConflictingImport) {
            JavaType owner = fieldType.getOwner();
            while (owner instanceof JavaType.FullyQualified) {
                this.maybeRemoveImport(((JavaType.FullyQualified)owner).getFullyQualifiedName());
                owner = ((JavaType.FullyQualified)owner).getOwningClass();
            }
            if (expression instanceof J.Identifier) {
                String realName;
                String string = realName = hasNoConflictingImport ? this.newConstantName : this.newTargetType.getFullyQualifiedName();
                if (hasNoConflictingImport) {
                    this.maybeAddImport(this.newOwningType.getFullyQualifiedName(), this.newConstantName, false);
                }
                J.Identifier identifier = (J.Identifier)expression;
                return identifier.withSimpleName(realName).withFieldType(fieldType.withOwner(this.newOwningType).withName(realName));
            }
            if (expression instanceof J.FieldAccess) {
                String realName;
                if (hasNoConflictingImport) {
                    this.maybeAddImport(this.newOwningType.getFullyQualifiedName(), false);
                }
                J.FieldAccess fieldAccess = (J.FieldAccess)expression;
                Expression target = fieldAccess.getTarget();
                J.Identifier name = fieldAccess.getName();
                String string = realName = hasNoConflictingImport ? this.newOwningType.getClassName() : this.newOwningType.getFullyQualifiedName();
                if (target instanceof J.Identifier) {
                    target = ((J.Identifier)target).withType(this.newOwningType).withSimpleName(realName);
                    name = name.withFieldType(fieldType.withOwner(this.newOwningType).withName(this.newConstantName)).withSimpleName(this.newConstantName);
                } else {
                    target = ((J.FieldAccess)target).getName().withType(this.newOwningType).withSimpleName(realName);
                    name = name.withFieldType(fieldType.withOwner(this.newOwningType).withName(this.newConstantName)).withSimpleName(this.newConstantName);
                }
                return fieldAccess.withTarget(target).withName(name);
            }
            return expression;
        }

        private boolean isConstant(@Nullable JavaType.Variable varType) {
            return varType != null && TypeUtils.isOfClassType(varType.getOwner(), this.existingOwningType) && varType.getName().equals(this.constantName);
        }

        private boolean hasNoConflictingImport(@Nullable JavaSourceFile sf) {
            return this.hasNoConflictingImport(sf, this.newOwningType) && this.hasNoConflictingImport(sf, this.newTargetType);
        }

        private boolean hasNoConflictingImport(@Nullable JavaSourceFile sf, JavaType.FullyQualified targetType) {
            if (sf == null || targetType == null) {
                return true;
            }
            for (J.Import anImport : sf.getImports()) {
                if (anImport.isStatic()) {
                    JavaType.FullyQualified fqn = TypeUtils.asFullyQualified(anImport.getQualid().getTarget().getType());
                    if (!anImport.getQualid().getSimpleName().equals(this.newConstantName) || TypeUtils.isOfClassType(fqn, this.newOwningType.getFullyQualifiedName()) || anImport.getQualid().getSimpleName().equals(this.constantName) && TypeUtils.isOfClassType(fqn, this.existingOwningTypeFqn.getFullyQualifiedName())) continue;
                    return false;
                }
                JavaType.FullyQualified currType = TypeUtils.asFullyQualified(anImport.getQualid().getType());
                if (currType == null || TypeUtils.isOfType(currType, targetType) || !currType.getClassName().equals(targetType.getClassName())) continue;
                return false;
            }
            return true;
        }
    }
}

