/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.whitespace;

import java.util.Locale;
import java.util.function.UnaryOperator;
import org.openrewrite.tools.checkstyle.StatelessCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.checks.whitespace.WrapOption;
import org.openrewrite.tools.checkstyle.utils.CommonUtil;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

@StatelessCheck
public class OperatorWrapCheck
extends AbstractCheck {
    public static final String MSG_LINE_NEW = "line.new";
    public static final String MSG_LINE_PREVIOUS = "line.previous";
    private WrapOption option = WrapOption.NL;

    public void setOption(String optionStr) {
        this.option = WrapOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{109, 82, 116, 115, 127, 125, 126, 60, 128, 123, 124, 120, 118, 122, 119, 117, 113, 112, 110, 114, 111, 174, 121};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{109, 82, 116, 115, 127, 125, 126, 60, 128, 123, 124, 120, 118, 122, 119, 117, 113, 112, 110, 114, 111, 121, 174, 80, 101, 98, 99, 100, 102, 103, 104, 105, 107, 108, 106, 180};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (OperatorWrapCheck.isTargetNode(ast)) {
            if (this.option == WrapOption.NL && OperatorWrapCheck.isNewLineModeViolation(ast)) {
                this.log(ast, MSG_LINE_NEW, ast.getText());
            } else if (this.option == WrapOption.EOL && OperatorWrapCheck.isEndOfLineModeViolation(ast)) {
                this.log(ast, MSG_LINE_PREVIOUS, ast.getText());
            }
        }
    }

    private static boolean isTargetNode(DetailAST node) {
        boolean result = node.getType() == 82 ? !OperatorWrapCheck.isColonFromLabel(node) : (node.getType() == 60 ? node.hasChildren() : true);
        return result;
    }

    private static boolean isNewLineModeViolation(DetailAST ast) {
        return TokenUtil.areOnSameLine(ast, OperatorWrapCheck.getLeftNode(ast)) && !TokenUtil.areOnSameLine(ast, OperatorWrapCheck.getRightNode(ast));
    }

    private static boolean isEndOfLineModeViolation(DetailAST ast) {
        return !TokenUtil.areOnSameLine(ast, OperatorWrapCheck.getLeftNode(ast));
    }

    private static boolean isColonFromLabel(DetailAST node) {
        return TokenUtil.isOfType(node.getParent(), 22, 93, 94);
    }

    private static boolean isAssignToVariable(DetailAST node) {
        return TokenUtil.isOfType(node.getParent(), 10, 178);
    }

    private static DetailAST getLeftNode(DetailAST node) {
        DetailAST result = node.getFirstChild() == null || OperatorWrapCheck.isAssignToVariable(node) ? node.getPreviousSibling() : (OperatorWrapCheck.isInPatternDefinition(node) ? node.getFirstChild() : OperatorWrapCheck.adjustParens(node.getFirstChild(), DetailAST::getNextSibling));
        while (result.getLastChild() != null) {
            result = result.getLastChild();
        }
        return result;
    }

    private static boolean isInPatternDefinition(DetailAST node) {
        DetailAST parent = node;
        int[] tokensToStopOn = new int[]{213, 28, 178, 1};
        while (!TokenUtil.isOfType(parent = parent.getParent(), tokensToStopOn)) {
        }
        return parent.getType() == 213;
    }

    private static DetailAST getRightNode(DetailAST node) {
        DetailAST result;
        if (node.getLastChild() == null) {
            result = node.getNextSibling();
        } else {
            DetailAST rightNode = node.getType() == 109 ? node.findFirstToken(82).getPreviousSibling() : node.getLastChild();
            result = OperatorWrapCheck.adjustParens(rightNode, DetailAST::getPreviousSibling);
        }
        if (!TokenUtil.isOfType(result, 29, 162)) {
            while (result.getFirstChild() != null) {
                result = result.getFirstChild();
            }
        }
        return result;
    }

    private static DetailAST adjustParens(DetailAST node, UnaryOperator<DetailAST> step) {
        DetailAST result = node;
        int accumulator = 0;
        while (true) {
            if (result.getType() == 76) {
                --accumulator;
            } else if (result.getType() == 77) {
                ++accumulator;
            }
            if (accumulator == 0) break;
            result = (DetailAST)step.apply(result);
        }
        return result;
    }
}

