/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.parser;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.java.JavaParserExecutionContextView;
import org.openrewrite.java.internal.parser.JavaParserCaller;
import org.openrewrite.java.internal.parser.JavaParserClasspathLoader;

public class RewriteClasspathJarClasspathLoader
implements JavaParserClasspathLoader,
AutoCloseable {
    private final Class<?> caller = JavaParserCaller.findCaller();
    private final ScanResult result;
    private final ResourceList resources;
    private final ExecutionContext ctx;

    public RewriteClasspathJarClasspathLoader(ExecutionContext ctx) {
        this.ctx = ctx;
        this.result = new ClassGraph().acceptPaths(new String[]{"META-INF/rewrite/classpath"}).scan();
        this.resources = this.result.getResourcesWithExtension(".jar");
    }

    @Override
    public @Nullable Path load(String artifactName) {
        Pattern jarPattern = Pattern.compile(artifactName + "-?.*\\.jar$");
        for (Resource resource : this.resources) {
            if (!jarPattern.matcher(resource.getPath()).find()) continue;
            try {
                Path artifact = RewriteClasspathJarClasspathLoader.getJarsFolder(this.ctx).resolve(Paths.get(resource.getPath(), new String[0]).getFileName());
                if (!Files.exists(artifact, new LinkOption[0])) {
                    try {
                        InputStream resourceAsStream = Objects.requireNonNull(this.caller.getResourceAsStream("/" + resource.getPath()), this.caller.getCanonicalName() + " resource not found: " + resource.getPath());
                        Files.copy(resourceAsStream, artifact, new CopyOption[0]);
                    }
                    catch (FileAlreadyExistsException fileAlreadyExistsException) {
                        // empty catch block
                    }
                }
                return artifact;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return null;
    }

    private static Path getJarsFolder(ExecutionContext ctx) {
        Path jarsFolder = JavaParserExecutionContextView.view(ctx).getParserClasspathDownloadTarget().toPath().resolve(".jars");
        if (!Files.exists(jarsFolder, new LinkOption[0]) && !jarsFolder.toFile().mkdirs()) {
            throw new UncheckedIOException(new IOException("Failed to create directory " + jarsFolder));
        }
        return jarsFolder;
    }

    @Override
    public void close() {
        this.resources.close();
        this.result.close();
    }
}

