/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

public class CountLinesVisitor
extends JavaVisitor<AtomicInteger> {
    public J visit(@Nullable Tree tree, AtomicInteger count) {
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
            if (cu.getPackageDeclaration() != null) {
                count.incrementAndGet();
            }
            count.getAndAdd(cu.getImports().size());
            for (J.ClassDeclaration c : cu.getClasses()) {
                this.visit((Tree)c, count);
            }
            return cu;
        }
        return (J)super.visit(tree, (Object)count);
    }

    @Override
    public J visitBlock(J.Block block, AtomicInteger count) {
        for (Statement s : block.getStatements()) {
            this.visit((Tree)s, count);
        }
        return block;
    }

    @Override
    public Space visitSpace(Space space, Space.Location loc, AtomicInteger count) {
        if (space.getWhitespace().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitSpace(space, loc, count);
    }

    public static int countLines(Tree tree) {
        return ((AtomicInteger)new CountLinesVisitor().reduce(tree, new AtomicInteger())).get();
    }
}

