/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.format;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.format.SpacesVisitor;
import org.openrewrite.hcl.style.SpacesStyle;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.style.Style;

public class Spaces
extends Recipe {
    public String getDisplayName() {
        return "Spaces";
    }

    public String getDescription() {
        return "Format whitespace in HCL code.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new SpacesFromCompilationUnitStyle();
    }

    private static class SpacesFromCompilationUnitStyle
    extends HclIsoVisitor<ExecutionContext> {
        private SpacesFromCompilationUnitStyle() {
        }

        @Override
        public Hcl.ConfigFile visitConfigFile(Hcl.ConfigFile cf, ExecutionContext ctx) {
            SpacesStyle style = (SpacesStyle)Style.from(SpacesStyle.class, (SourceFile)cf, () -> SpacesStyle.DEFAULT);
            return (Hcl.ConfigFile)new SpacesVisitor(style).visitNonNull(cf, ctx);
        }
    }
}

