/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.trait;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.gradle.trait.GradleTraitMatcher;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.maven.tree.DependencyNotation;
import org.openrewrite.semver.DependencyMatcher;
import org.openrewrite.trait.Trait;
import org.openrewrite.trait.VisitFunction2;

public final class GradleMultiDependency
implements Trait<J.MethodInvocation> {
    private final Cursor cursor;
    private final @Nullable DependencyMatcher matcher;
    private final boolean varargs;

    public String getConfigurationName() {
        return ((J.MethodInvocation)this.getTree()).getSimpleName();
    }

    private static boolean methodArgumentsContainMultipleDependencyNotations(Cursor methodCursor) {
        Object maybeMi = methodCursor.getValue();
        if (!(maybeMi instanceof J.MethodInvocation)) {
            return false;
        }
        J.MethodInvocation m = (J.MethodInvocation)maybeMi;
        long count = m.getArguments().stream().filter(it -> {
            String printed = it.print(methodCursor).trim();
            if (printed.startsWith("'") && printed.endsWith("'") || printed.startsWith("\"") && printed.endsWith("\"")) {
                printed = printed.substring(1, printed.length() - 1);
            }
            return DependencyNotation.parse((String)printed) != null;
        }).limit(2L).count();
        return m.getArguments().size() > 1 && count > 1L;
    }

    public J.MethodInvocation map(Function<GradleDependency, J.MethodInvocation> mapper) {
        if (this.isVarargs()) {
            return ((J.MethodInvocation)this.getTree()).withArguments(ListUtils.map((List)((J.MethodInvocation)this.getTree()).getArguments(), argument -> {
                J.MethodInvocation m = ((J.MethodInvocation)this.getTree()).withArguments(Collections.singletonList(argument));
                Optional dep = new GradleDependency.Matcher().matcher(this.matcher).get(new Cursor(this.getCursor().getParent(), (Object)m));
                if (dep.isPresent()) {
                    J.MethodInvocation result = (J.MethodInvocation)mapper.apply((GradleDependency)dep.get());
                    return (Expression)result.getArguments().get(0);
                }
                return argument;
            }));
        }
        Optional dep = new GradleDependency.Matcher().matcher(this.matcher).get(this.cursor);
        if (dep.isPresent()) {
            return mapper.apply((GradleDependency)dep.get());
        }
        return (J.MethodInvocation)this.getTree();
    }

    public void forEach(Consumer<GradleDependency> consumer) {
        if (this.isVarargs()) {
            for (Expression argument : ((J.MethodInvocation)this.getTree()).getArguments()) {
                J.MethodInvocation m = ((J.MethodInvocation)this.getTree()).withArguments(Collections.singletonList(argument));
                new GradleDependency.Matcher().matcher(this.matcher).get(new Cursor(this.getCursor().getParent(), (Object)m)).ifPresent(consumer);
            }
        } else {
            new GradleDependency.Matcher().matcher(this.matcher).get(this.cursor).ifPresent(consumer);
        }
    }

    public static Matcher matcher() {
        return new Matcher();
    }

    @Generated
    public GradleMultiDependency(Cursor cursor, @Nullable DependencyMatcher matcher, boolean varargs) {
        this.cursor = cursor;
        this.matcher = matcher;
        this.varargs = varargs;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public @Nullable DependencyMatcher getMatcher() {
        return this.matcher;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleMultiDependency)) {
            return false;
        }
        GradleMultiDependency other = (GradleMultiDependency)o;
        if (this.isVarargs() != other.isVarargs()) {
            return false;
        }
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        DependencyMatcher this$matcher = this.getMatcher();
        DependencyMatcher other$matcher = other.getMatcher();
        return !(this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isVarargs() ? 79 : 97);
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        DependencyMatcher $matcher = this.getMatcher();
        result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "GradleMultiDependency(cursor=" + this.getCursor() + ", matcher=" + this.getMatcher() + ", varargs=" + this.isVarargs() + ")";
    }

    @NonNull
    @Generated
    public GradleMultiDependency withCursor(Cursor cursor) {
        return this.cursor == cursor ? this : new GradleMultiDependency(cursor, this.matcher, this.varargs);
    }

    @Generated
    public boolean isVarargs() {
        return this.varargs;
    }

    public static class Matcher
    extends GradleTraitMatcher<GradleMultiDependency> {
        protected @Nullable String configuration;
        protected @Nullable DependencyMatcher matcher;

        public Matcher matcher(@Nullable DependencyMatcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public Matcher configuration(@Nullable String configuration) {
            this.configuration = configuration;
            return this;
        }

        public Matcher groupId(@Nullable String groupPattern) {
            this.matcher = this.matcher == null ? new DependencyMatcher(groupPattern, null, null) : this.matcher.withGroupPattern(groupPattern);
            return this;
        }

        public Matcher artifactId(@Nullable String artifactPattern) {
            this.matcher = this.matcher == null ? new DependencyMatcher(null, artifactPattern, null) : this.matcher.withArtifactPattern(artifactPattern);
            return this;
        }

        public <P> TreeVisitor<? extends Tree, P> asVisitor(final VisitFunction2<GradleMultiDependency, P> visitor) {
            return new JavaVisitor<P>(){

                public J visitMethodInvocation(J.MethodInvocation method, P p) {
                    GradleMultiDependency multiDependency = this.test(this.getCursor());
                    return multiDependency != null ? (J)visitor.visit((Trait)multiDependency, p) : super.visitMethodInvocation(method, p);
                }
            };
        }

        protected @Nullable GradleMultiDependency test(Cursor cursor) {
            if (!GradleDependency.isDependencyDeclaration(cursor)) {
                return null;
            }
            J.MethodInvocation methodInvocation = (J.MethodInvocation)cursor.getValue();
            if (!StringUtils.isBlank((String)this.configuration) && !methodInvocation.getSimpleName().equals(this.configuration)) {
                return null;
            }
            return new GradleMultiDependency(cursor, this.matcher, GradleMultiDependency.methodArgumentsContainMultipleDependencyNotations(cursor));
        }
    }
}

