/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.gradle.DependencyVersionSelector;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.marker.GradleSettings;
import org.openrewrite.gradle.search.FindPlugins;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.FindMethods;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.tree.ParseError;

public final class AddPluginVisitor
extends JavaIsoVisitor<ExecutionContext> {
    private final String pluginId;
    private final @Nullable String newVersion;
    private final @Nullable String versionPattern;
    private final @Nullable Boolean apply;
    private final @Nullable Boolean acceptTransitive;

    private static @Nullable Comment getLicenseHeader(Tree tree) {
        Comment firstComment;
        Comment firstComment2;
        Statement firstStatement;
        G.CompilationUnit cu;
        if (tree instanceof G.CompilationUnit) {
            cu = (G.CompilationUnit)tree;
            if (!cu.getStatements().isEmpty()) {
                firstStatement = (Statement)cu.getStatements().get(0);
                if (!firstStatement.getComments().isEmpty() && AddPluginVisitor.isLicenseHeader(firstComment2 = (Comment)firstStatement.getComments().get(0))) {
                    return firstComment2;
                }
            } else if (cu.getEof() != null && !cu.getEof().getComments().isEmpty() && AddPluginVisitor.isLicenseHeader(firstComment = (Comment)cu.getEof().getComments().get(0))) {
                return firstComment.withSuffix("\n\n");
            }
        }
        if (tree instanceof K.CompilationUnit) {
            cu = (K.CompilationUnit)tree;
            if (!cu.getStatements().isEmpty()) {
                firstStatement = (Statement)cu.getStatements().get(0);
                if (firstStatement instanceof J.Block && !((J.Block)firstStatement).getStatements().isEmpty()) {
                    firstStatement = (Statement)((J.Block)firstStatement).getStatements().get(0);
                }
                if (!firstStatement.getComments().isEmpty() && AddPluginVisitor.isLicenseHeader(firstComment2 = (Comment)firstStatement.getComments().get(0))) {
                    return firstComment2;
                }
            } else if (cu.getEof() != null && !cu.getEof().getComments().isEmpty() && AddPluginVisitor.isLicenseHeader(firstComment = (Comment)cu.getEof().getComments().get(0))) {
                return firstComment.withSuffix("\n\n");
            }
        }
        return null;
    }

    private static boolean isLicenseHeader(Comment comment) {
        return comment instanceof TextComment && comment.isMultiline() && ((TextComment)comment).getText().contains("License");
    }

    private static Tree removeLicenseHeader(Tree tree) {
        if (tree instanceof G.CompilationUnit) {
            G.CompilationUnit cu = (G.CompilationUnit)tree;
            if (!cu.getStatements().isEmpty()) {
                return cu.withStatements(ListUtils.mapFirst((List)cu.getStatements(), s -> (Statement)s.withComments(s.getComments().subList(1, s.getComments().size()))));
            }
            List eofComments = cu.getEof().getComments();
            return cu.withEof(cu.getEof().withComments(eofComments.subList(1, eofComments.size())));
        }
        if (tree instanceof K.CompilationUnit) {
            K.CompilationUnit cu = (K.CompilationUnit)tree;
            if (!cu.getStatements().isEmpty()) {
                if (cu.getStatements().get(0) instanceof J.Block && !((J.Block)cu.getStatements().get(0)).getStatements().isEmpty()) {
                    return cu.withStatements(ListUtils.mapFirst((List)cu.getStatements(), b -> ((J.Block)b).withStatements(ListUtils.mapFirst((List)((J.Block)b).getStatements(), s -> {
                        if (!s.getComments().isEmpty() && AddPluginVisitor.isLicenseHeader((Comment)s.getComments().get(0))) {
                            return (Statement)s.withComments(s.getComments().subList(1, s.getComments().size()));
                        }
                        return s;
                    }))));
                }
            } else {
                List eofComments = cu.getEof().getComments();
                return cu.withEof(cu.getEof().withComments(eofComments.subList(1, eofComments.size())));
            }
        }
        return tree;
    }

    public @Nullable J preVisit(@org.jspecify.annotations.NonNull J tree, ExecutionContext ctx) {
        if (tree instanceof JavaSourceFile) {
            if (tree instanceof G.CompilationUnit) {
                return this.addPluginToGroovyCompilationUnit((G.CompilationUnit)tree, ctx);
            }
            if (tree instanceof K.CompilationUnit) {
                return this.addPluginToKotlinCompilationUnit((K.CompilationUnit)tree, ctx);
            }
        }
        return (J)super.preVisit((Tree)tree, (Object)ctx);
    }

    private G.CompilationUnit addPluginToGroovyCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
        String version;
        if (!FindPlugins.find((J)cu, this.pluginId).isEmpty() && (this.acceptTransitive == null || this.acceptTransitive.booleanValue())) {
            return cu;
        }
        if (this.newVersion == null) {
            version = null;
        } else {
            Optional maybeGp = cu.getMarkers().findFirst(GradleProject.class);
            Optional maybeGs = cu.getMarkers().findFirst(GradleSettings.class);
            if (!maybeGp.isPresent() && !maybeGs.isPresent()) {
                return cu;
            }
            try {
                version = new DependencyVersionSelector(null, maybeGp.orElse(null), maybeGs.orElse(null)).select(new GroupArtifact(this.pluginId, this.pluginId + ".gradle.plugin"), "classpath", this.newVersion, this.versionPattern, ctx);
            }
            catch (MavenDownloadingException e) {
                return (G.CompilationUnit)e.warn((Tree)cu);
            }
        }
        final AtomicInteger singleQuote = new AtomicInteger();
        final AtomicInteger doubleQuote = new AtomicInteger();
        final AtomicBoolean pluginAlreadyApplied = new AtomicBoolean();
        new JavaIsoVisitor<Integer>(){
            final MethodMatcher pluginIdMatcher = new MethodMatcher("PluginSpec id(..)");

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Integer integer) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)integer);
                if (this.pluginIdMatcher.matches((MethodCall)m) && m.getArguments().get(0) instanceof J.Literal) {
                    J.Literal l = (J.Literal)m.getArguments().get(0);
                    if (AddPluginVisitor.this.pluginId.equals(l.getValue())) {
                        pluginAlreadyApplied.set(true);
                    }
                    assert (l.getValueSource() != null);
                    if (l.getValueSource().startsWith("'")) {
                        singleQuote.incrementAndGet();
                    } else {
                        doubleQuote.incrementAndGet();
                    }
                }
                return m;
            }
        }.visit((Tree)cu, (Object)0);
        if (pluginAlreadyApplied.get()) {
            return cu;
        }
        String delimiter = singleQuote.get() < doubleQuote.get() ? "\"" : "'";
        String source = "plugins {\n    id " + delimiter + this.pluginId + delimiter + (version != null ? " version " + delimiter + version + delimiter : "") + (version != null && Boolean.FALSE.equals(this.apply) ? " apply " + this.apply : "") + "\n}";
        Statement statement = GradleParser.builder().build().parseInputs(Collections.singletonList(Parser.Input.fromString((String)source)), null, ctx).findFirst().map(parsed -> {
            if (parsed instanceof ParseError) {
                throw ((ParseError)parsed).toException();
            }
            return (G.CompilationUnit)parsed;
        }).map(parsed -> (Statement)parsed.getStatements().get(0)).orElseThrow(() -> new IllegalArgumentException("Could not parse as Gradle"));
        if (FindMethods.find((J)cu, (String)"RewriteGradleProject plugins(..)").isEmpty() && FindMethods.find((J)cu, (String)"RewriteSettings plugins(..)").isEmpty()) {
            if (cu.getSourcePath().endsWith(Paths.get("settings.gradle", new String[0])) && !cu.getStatements().isEmpty() && cu.getStatements().get(0) instanceof J.MethodInvocation && "pluginManagement".equals(((J.MethodInvocation)cu.getStatements().get(0)).getSimpleName())) {
                return cu.withStatements(ListUtils.insert((List)cu.getStatements(), (Object)((Statement)this.autoFormat((J)((Statement)statement.withPrefix(Space.format((String)"\n\n"))), ctx, this.getCursor())), (int)1));
            }
            int insertAtIdx = 0;
            for (int i = 0; i < cu.getStatements().size(); ++i) {
                Statement existingStatement = (Statement)cu.getStatements().get(i);
                if (!(existingStatement instanceof J.MethodInvocation) || !"buildscript".equals(((J.MethodInvocation)existingStatement).getSimpleName())) continue;
                insertAtIdx = i + 1;
                break;
            }
            if (insertAtIdx == 0) {
                Comment licenseHeader = AddPluginVisitor.getLicenseHeader((Tree)cu);
                if (licenseHeader != null) {
                    cu = (G.CompilationUnit)AddPluginVisitor.removeLicenseHeader((Tree)cu);
                    statement = (Statement)statement.withComments(Collections.singletonList(licenseHeader));
                }
                Space leadingSpace = Space.firstPrefix((List)cu.getStatements());
                return cu.withStatements(ListUtils.insert((List)Space.formatFirstPrefix((List)cu.getStatements(), (Space)leadingSpace.withWhitespace("\n\n" + leadingSpace.getWhitespace())), (Object)((Statement)this.autoFormat((J)statement, ctx, this.getCursor())), (int)insertAtIdx));
            }
            return cu.withStatements(ListUtils.insert((List)cu.getStatements(), (Object)((Statement)this.autoFormat((J)((Statement)statement.withPrefix(Space.format((String)"\n\n"))), ctx, this.getCursor())), (int)insertAtIdx));
        }
        MethodMatcher buildPluginsMatcher = new MethodMatcher("RewriteGradleProject plugins(groovy.lang.Closure)");
        MethodMatcher settingsPluginsMatcher = new MethodMatcher("RewriteSettings plugins(groovy.lang.Closure)");
        J.MethodInvocation pluginDef = (J.MethodInvocation)((J.Return)((J.Block)((J.Lambda)((J.MethodInvocation)this.autoFormat((J)statement, ctx, this.getCursor())).getArguments().get(0)).getBody()).getStatements().get(0)).getExpression();
        return cu.withStatements(ListUtils.map((List)cu.getStatements(), stat -> {
            J.MethodInvocation m;
            if (stat instanceof J.MethodInvocation && (buildPluginsMatcher.matches((MethodCall)(m = (J.MethodInvocation)stat)) || settingsPluginsMatcher.matches((MethodCall)m))) {
                return m.withArguments(ListUtils.map((List)m.getArguments(), a -> {
                    if (a instanceof J.Lambda) {
                        J.Lambda l = (J.Lambda)a;
                        J.Block b = (J.Block)l.getBody();
                        List pluginStatements = b.getStatements();
                        if (!pluginStatements.isEmpty() && pluginStatements.get(pluginStatements.size() - 1) instanceof J.Return) {
                            Statement last = (Statement)pluginStatements.remove(pluginStatements.size() - 1);
                            Expression lastExpr = Objects.requireNonNull(((J.Return)last).getExpression());
                            pluginStatements.add((Statement)lastExpr.withPrefix(last.getPrefix()));
                        }
                        pluginStatements.add(pluginDef);
                        return l.withBody(this.autoFormat((J)b.withStatements(pluginStatements), ctx, this.getCursor()));
                    }
                    return a;
                }));
            }
            return stat;
        }));
    }

    private K.CompilationUnit addPluginToKotlinCompilationUnit(K.CompilationUnit cu, ExecutionContext ctx) {
        String version;
        final MethodMatcher pluginsMatcher = new MethodMatcher("*..* plugins(..)");
        final MethodMatcher pluginIdMatcher = new MethodMatcher("*..* id(..)");
        AtomicBoolean hasPlugin = (AtomicBoolean)new JavaIsoVisitor<AtomicBoolean>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicBoolean found) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)found);
                if (pluginIdMatcher.matches(m, true) && m.getArguments().get(0) instanceof J.Literal) {
                    J.Literal l = (J.Literal)m.getArguments().get(0);
                    if (AddPluginVisitor.this.pluginId.equals(l.getValue())) {
                        found.set(true);
                        return m;
                    }
                }
                return m;
            }
        }.reduce((Tree)cu, (Object)new AtomicBoolean());
        if (hasPlugin.get()) {
            return cu;
        }
        if (this.newVersion == null) {
            version = null;
        } else {
            Optional maybeGp = cu.getMarkers().findFirst(GradleProject.class);
            Optional maybeGs = cu.getMarkers().findFirst(GradleSettings.class);
            if (!maybeGp.isPresent() && !maybeGs.isPresent()) {
                return cu;
            }
            try {
                version = new DependencyVersionSelector(null, maybeGp.orElse(null), maybeGs.orElse(null)).select(new GroupArtifact(this.pluginId, this.pluginId + ".gradle.plugin"), "classpath", this.newVersion, this.versionPattern, ctx);
            }
            catch (MavenDownloadingException e) {
                return (K.CompilationUnit)e.warn((Tree)cu);
            }
        }
        String source = "plugins {\n    id(\"" + this.pluginId + "\")" + (version != null ? " version \"" + version + "\"" : "") + (version != null && Boolean.FALSE.equals(this.apply) ? " apply " + this.apply : "") + "\n}";
        Statement statement = GradleParser.builder().build().parseInputs(Collections.singletonList(Parser.Input.fromString((Path)Paths.get("build.gradle.kts", new String[0]), (String)source)), null, ctx).findFirst().map(parsed -> {
            if (parsed instanceof ParseError) {
                throw ((ParseError)parsed).toException();
            }
            return (K.CompilationUnit)parsed;
        }).map(parsed -> (Statement)parsed.getStatements().get(0)).map(block -> (Statement)((J.Block)block).getStatements().get(0)).orElseThrow(() -> new IllegalArgumentException("Could not parse as Gradle"));
        AtomicBoolean hasPluginsBlock = (AtomicBoolean)new JavaIsoVisitor<AtomicBoolean>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicBoolean found) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)found);
                if (pluginsMatcher.matches(m, true)) {
                    found.set(true);
                }
                return m;
            }
        }.reduce((Tree)cu, (Object)new AtomicBoolean());
        if (!hasPluginsBlock.get()) {
            J.Block block2 = (J.Block)cu.getStatements().get(0);
            if (cu.getSourcePath().endsWith(Paths.get("settings.gradle", new String[0])) && !block2.getStatements().isEmpty() && block2.getStatements().get(0) instanceof J.MethodInvocation && "pluginManagement".equals(((J.MethodInvocation)block2.getStatements().get(0)).getSimpleName())) {
                block2 = block2.withStatements(ListUtils.insert((List)block2.getStatements(), (Object)((Statement)this.autoFormat((J)((Statement)statement.withPrefix(Space.format((String)"\n\n"))), ctx, this.getCursor())), (int)1));
            } else {
                int insertAtIdx = 0;
                for (int i = 0; i < cu.getStatements().size(); ++i) {
                    Statement existingStatement = (Statement)cu.getStatements().get(i);
                    if (!(existingStatement instanceof J.MethodInvocation) || !"buildscript".equals(((J.MethodInvocation)existingStatement).getSimpleName())) continue;
                    insertAtIdx = i + 1;
                    break;
                }
                if (insertAtIdx == 0) {
                    Comment licenseHeader = AddPluginVisitor.getLicenseHeader((Tree)cu);
                    if (licenseHeader != null) {
                        cu = (K.CompilationUnit)AddPluginVisitor.removeLicenseHeader((Tree)cu);
                        block2 = (J.Block)cu.getStatements().get(0);
                        statement = (Statement)statement.withComments(Collections.singletonList(licenseHeader));
                    }
                    Space leadingSpace = Space.firstPrefix((List)block2.getStatements());
                    block2 = block2.withStatements(ListUtils.insert((List)Space.formatFirstPrefix((List)block2.getStatements(), (Space)leadingSpace.withWhitespace("\n\n" + leadingSpace.getWhitespace())), (Object)statement, (int)insertAtIdx));
                } else {
                    block2 = block2.withStatements(ListUtils.insert((List)block2.getStatements(), (Object)((Statement)statement.withPrefix(Space.format((String)"\n\n"))), (int)insertAtIdx));
                }
            }
            J.Block newStatement = block2;
            return cu.withStatements(ListUtils.mapFirst((List)cu.getStatements(), __ -> newStatement));
        }
        J.MethodInvocation pluginDef = (J.MethodInvocation)((J.Block)((J.Lambda)((J.MethodInvocation)statement).getArguments().get(0)).getBody()).getStatements().get(0);
        return cu.withStatements(ListUtils.mapFirst((List)cu.getStatements(), b -> {
            if (b instanceof J.Block) {
                J.Block block = (J.Block)b;
                return block.withStatements(ListUtils.map((List)block.getStatements(), stat -> {
                    J.MethodInvocation m;
                    if (stat instanceof J.MethodInvocation && pluginsMatcher.matches(m = (J.MethodInvocation)stat, true)) {
                        return m.withArguments(ListUtils.map((List)m.getArguments(), a -> {
                            if (a instanceof J.Lambda) {
                                J.Lambda l = (J.Lambda)a;
                                J.Block body = (J.Block)l.getBody();
                                List pluginStatements = body.getStatements();
                                if (!pluginStatements.isEmpty() && pluginStatements.get(pluginStatements.size() - 1) instanceof J.Return) {
                                    Statement last = (Statement)pluginStatements.remove(pluginStatements.size() - 1);
                                    Expression lastExpr = Objects.requireNonNull(((J.Return)last).getExpression());
                                    pluginStatements.add((Statement)lastExpr.withPrefix(last.getPrefix()));
                                } else if (pluginStatements.isEmpty()) {
                                    body = body.withPrefix(Space.EMPTY).withEnd(Space.build((String)"\n", Collections.emptyList()));
                                }
                                pluginStatements.add(pluginDef);
                                return l.withBody((J)body.withStatements(pluginStatements));
                            }
                            return a;
                        }));
                    }
                    return stat;
                }));
            }
            return b;
        }));
    }

    @Generated
    public AddPluginVisitor(String pluginId, @Nullable String newVersion, @Nullable String versionPattern, @Nullable Boolean apply, @Nullable Boolean acceptTransitive) {
        this.pluginId = pluginId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.apply = apply;
        this.acceptTransitive = acceptTransitive;
    }

    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @Generated
    public @Nullable String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public @Nullable Boolean getApply() {
        return this.apply;
    }

    @Generated
    public @Nullable Boolean getAcceptTransitive() {
        return this.acceptTransitive;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddPluginVisitor(pluginId=" + this.getPluginId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", apply=" + this.getApply() + ", acceptTransitive=" + this.getAcceptTransitive() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddPluginVisitor)) {
            return false;
        }
        AddPluginVisitor other = (AddPluginVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$apply = this.getApply();
        Boolean other$apply = other.getApply();
        if (this$apply == null ? other$apply != null : !((Object)this$apply).equals(other$apply)) {
            return false;
        }
        Boolean this$acceptTransitive = this.getAcceptTransitive();
        Boolean other$acceptTransitive = other.getAcceptTransitive();
        if (this$acceptTransitive == null ? other$acceptTransitive != null : !((Object)this$acceptTransitive).equals(other$acceptTransitive)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddPluginVisitor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $apply = this.getApply();
        result = result * 59 + ($apply == null ? 43 : ((Object)$apply).hashCode());
        Boolean $acceptTransitive = this.getAcceptTransitive();
        result = result * 59 + ($acceptTransitive == null ? 43 : ((Object)$acceptTransitive).hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

