/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class TimeRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`TimeRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with time.\n[Source](https://error-prone.picnic.tech/refasterrules/TimeRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new ClockInstantRecipe(), new UtcConstantRecipe(), new LocalDateOfInstantRecipe(), new LocalDateTimeOfInstantRecipe(), new LocalTimeOfInstantRecipe(), new OffsetDateTimeOfInstantRecipe(), new InstantIdentityRecipe(), new InstantTruncatedToMillisecondsRecipe(), new InstantTruncatedToSecondsRecipe(), new InstantAtOffsetRecipe(), new OffsetTimeOfInstantRecipe(), new InstantAtZoneRecipe(), new UtcClockRecipe(), new EpochInstantRecipe(), new InstantIsBeforeRecipe(), new InstantIsAfterRecipe(), new LocalTimeMinRecipe(), new LocalDateAtStartOfDayRecipe(), new ChronoLocalDateIsBeforeRecipe(), new ChronoLocalDateIsAfterRecipe(), new ChronoLocalDateTimeIsBeforeRecipe(), new ChronoLocalDateTimeIsAfterRecipe(), new ChronoZonedDateTimeIsBeforeRecipe(), new ChronoZonedDateTimeIsAfterRecipe(), new OffsetDateTimeIsBeforeRecipe(), new OffsetDateTimeIsAfterRecipe(), new ZeroDurationRecipe(), new DurationOfDaysRecipe(), new DurationOfHoursRecipe(), new DurationOfMillisRecipe(), new DurationOfMinutesRecipe(), new DurationOfNanosRecipe(), new DurationOfSecondsRecipe(), new DurationBetweenInstantsRecipe(), new DurationBetweenOffsetDateTimesRecipe(), new DurationIsZeroRecipe(), new ZeroPeriodRecipe(), new LocalDatePlusDaysRecipe(), new LocalDatePlusWeeksRecipe(), new LocalDatePlusMonthsRecipe(), new LocalDatePlusYearsRecipe(), new LocalDateMinusDaysRecipe(), new LocalDateMinusWeeksRecipe(), new LocalDateMinusMonthsRecipe(), new LocalDateMinusYearsRecipe(), new LocalTimePlusNanosRecipe(), new LocalTimePlusSecondsRecipe(), new LocalTimePlusMinutesRecipe(), new LocalTimePlusHoursRecipe(), new LocalTimeMinusNanosRecipe(), new LocalTimeMinusSecondsRecipe(), new LocalTimeMinusMinutesRecipe(), new LocalTimeMinusHoursRecipe(), new OffsetTimePlusNanosRecipe(), new OffsetTimePlusSecondsRecipe(), new OffsetTimePlusMinutesRecipe(), new OffsetTimePlusHoursRecipe(), new OffsetTimeMinusNanosRecipe(), new OffsetTimeMinusSecondsRecipe(), new OffsetTimeMinusMinutesRecipe(), new OffsetTimeMinusHoursRecipe(), new LocalDateTimePlusNanosRecipe(), new LocalDateTimePlusSecondsRecipe(), new LocalDateTimePlusMinutesRecipe(), new LocalDateTimePlusHoursRecipe(), new LocalDateTimePlusDaysRecipe(), new LocalDateTimePlusWeeksRecipe(), new LocalDateTimePlusMonthsRecipe(), new LocalDateTimePlusYearsRecipe(), new LocalDateTimeMinusNanosRecipe(), new LocalDateTimeMinusSecondsRecipe(), new LocalDateTimeMinusMinutesRecipe(), new LocalDateTimeMinusHoursRecipe(), new LocalDateTimeMinusDaysRecipe(), new LocalDateTimeMinusWeeksRecipe(), new LocalDateTimeMinusMonthsRecipe(), new LocalDateTimeMinusYearsRecipe(), new OffsetDateTimePlusNanosRecipe(), new OffsetDateTimePlusSecondsRecipe(), new OffsetDateTimePlusMinutesRecipe(), new OffsetDateTimePlusHoursRecipe(), new OffsetDateTimePlusDaysRecipe(), new OffsetDateTimePlusWeeksRecipe(), new OffsetDateTimePlusMonthsRecipe(), new OffsetDateTimePlusYearsRecipe(), new OffsetDateTimeMinusNanosRecipe(), new OffsetDateTimeMinusSecondsRecipe(), new OffsetDateTimeMinusMinutesRecipe(), new OffsetDateTimeMinusHoursRecipe(), new OffsetDateTimeMinusDaysRecipe(), new OffsetDateTimeMinusWeeksRecipe(), new OffsetDateTimeMinusMonthsRecipe(), new OffsetDateTimeMinusYearsRecipe(), new ZonedDateTimePlusNanosRecipe(), new ZonedDateTimePlusSecondsRecipe(), new ZonedDateTimePlusMinutesRecipe(), new ZonedDateTimePlusHoursRecipe(), new ZonedDateTimePlusDaysRecipe(), new ZonedDateTimePlusWeeksRecipe(), new ZonedDateTimePlusMonthsRecipe(), new ZonedDateTimePlusYearsRecipe(), new ZonedDateTimeMinusNanosRecipe(), new ZonedDateTimeMinusSecondsRecipe(), new ZonedDateTimeMinusMinutesRecipe(), new ZonedDateTimeMinusHoursRecipe(), new ZonedDateTimeMinusDaysRecipe(), new ZonedDateTimeMinusWeeksRecipe(), new ZonedDateTimeMinusMonthsRecipe(), new ZonedDateTimeMinusYearsRecipe()});
    }

    @NullMarked
    public static class ClockInstantRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ClockInstant`";
        }

        public String getDescription() {
            return "Prefer `Clock#instant()` over `Instant#now(Clock)`, as it is more concise and more \"OOP-py\".";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.time.Instant.now(#{clock:any(java.time.Clock)})").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{clock:any(java.time.Clock)}.instant()").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Clock", Boolean.valueOf(true)), new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesMethod("java.time.Instant now(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class UtcConstantRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.UtcConstant`";
        }

        public String getDescription() {
            return "Use `ZoneOffset#UTC` when possible.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before$4;
                JavaTemplate before$5;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.time.ZoneId.of(\"GMT\")").bindType("java.time.ZoneId").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.ZoneId");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.ZoneOffset.UTC").bindType("java.time.ZoneOffset").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.time.ZoneId.of(\"UTC\")").bindType("java.time.ZoneId").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.ZoneId");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.ZoneOffset.UTC").bindType("java.time.ZoneOffset").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.time.ZoneId.of(\"+0\")").bindType("java.time.ZoneId").build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.ZoneId");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.ZoneOffset.UTC").bindType("java.time.ZoneOffset").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"java.time.ZoneId.of(\"-0\")").bindType("java.time.ZoneId").build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.ZoneId");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.ZoneOffset.UTC").bindType("java.time.ZoneOffset").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$4 == null) {
                        this.before$4 = JavaTemplate.builder((String)"java.time.ZoneOffset.UTC.normalized()").bindType("java.time.ZoneId").build();
                    }
                    if ((matcher = this.before$4.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.ZoneId");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.ZoneOffset.UTC").bindType("java.time.ZoneOffset").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$5 == null) {
                        this.before$5 = JavaTemplate.builder((String)"java.time.ZoneId.from(java.time.ZoneOffset.UTC)").bindType("java.time.ZoneId").build();
                    }
                    if ((matcher = this.before$5.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.ZoneId");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.ZoneOffset.UTC").bindType("java.time.ZoneOffset").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZoneId", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.time.ZoneId from(..)", true), new UsesMethod("java.time.ZoneId of(..)", true), new UsesMethod("java.time.ZoneOffset normalized(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateOfInstantRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateOfInstant`";
        }

        public String getDescription() {
            return "Prefer `LocalDate#ofInstant(Instant, ZoneId)` over more indirect alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.atZone(#{zoneId:any(java.time.ZoneId)}).toLocalDate()").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalDate.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.time.LocalDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)}).toLocalDate()").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.LocalDateTime");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalDate.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.time.OffsetDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)}).toLocalDate()").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.OffsetDateTime");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalDate.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.atOffset(#{zoneId:any(java.time.ZoneOffset)}).toLocalDate()").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.ZoneOffset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalDate.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesType("java.time.LocalDate", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesType("java.time.ZoneId", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime ofInstant(..)", true), new UsesMethod("java.time.LocalDateTime toLocalDate(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesType("java.time.ZoneId", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime ofInstant(..)", true), new UsesMethod("java.time.OffsetDateTime toLocalDate(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZoneId", Boolean.valueOf(true)), new UsesMethod("java.time.Instant atZone(..)", true), new UsesMethod("java.time.ZonedDateTime toLocalDate(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZoneOffset", Boolean.valueOf(true)), new UsesMethod("java.time.Instant atOffset(..)", true), new UsesMethod("java.time.OffsetDateTime toLocalDate(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateTimeOfInstantRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateTimeOfInstant`";
        }

        public String getDescription() {
            return "Prefer `LocalDateTime#ofInstant(Instant, ZoneId)` over more indirect alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.atZone(#{zoneId:any(java.time.ZoneId)}).toLocalDateTime()").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.time.OffsetDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)}).toLocalDateTime()").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.OffsetDateTime");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.atOffset(#{zoneId:any(java.time.ZoneOffset)}).toLocalDateTime()").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.ZoneOffset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesType("java.time.ZoneId", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime ofInstant(..)", true), new UsesMethod("java.time.OffsetDateTime toLocalDateTime(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZoneId", Boolean.valueOf(true)), new UsesMethod("java.time.Instant atZone(..)", true), new UsesMethod("java.time.ZonedDateTime toLocalDateTime(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZoneOffset", Boolean.valueOf(true)), new UsesMethod("java.time.Instant atOffset(..)", true), new UsesMethod("java.time.OffsetDateTime toLocalDateTime(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalTimeOfInstantRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalTimeOfInstant`";
        }

        public String getDescription() {
            return "Prefer `LocalTime#ofInstant(Instant, ZoneId)` over more indirect alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.atZone(#{zoneId:any(java.time.ZoneId)}).toLocalTime()").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.time.LocalDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)}).toLocalTime()").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.LocalDateTime");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.time.OffsetDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)}).toLocalTime()").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.OffsetDateTime");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"java.time.OffsetTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)}).toLocalTime()").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.OffsetTime");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.atOffset(#{zoneId:any(java.time.ZoneOffset)}).toLocalTime()").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.ZoneOffset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesType("java.time.LocalTime", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesType("java.time.ZoneId", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime ofInstant(..)", true), new UsesMethod("java.time.LocalDateTime toLocalTime(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesType("java.time.ZoneId", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime ofInstant(..)", true), new UsesMethod("java.time.OffsetDateTime toLocalTime(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesType("java.time.ZoneId", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetTime ofInstant(..)", true), new UsesMethod("java.time.OffsetTime toLocalTime(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZoneId", Boolean.valueOf(true)), new UsesMethod("java.time.Instant atZone(..)", true), new UsesMethod("java.time.ZonedDateTime toLocalTime(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZoneOffset", Boolean.valueOf(true)), new UsesMethod("java.time.Instant atOffset(..)", true), new UsesMethod("java.time.OffsetDateTime toLocalTime(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimeOfInstantRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimeOfInstant`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#ofInstant(Instant, ZoneId)` over more indirect alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.atZone(#{zoneId:any(java.time.ZoneId)}).toOffsetDateTime()").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.OffsetDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesType("java.time.ZoneId", Boolean.valueOf(true)), new UsesMethod("java.time.Instant atZone(..)", true), new UsesMethod("java.time.ZonedDateTime toOffsetDateTime(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class InstantIdentityRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.InstantIdentity`";
        }

        public String getDescription() {
            return "Don't unnecessarily transform an `Instant` to an equivalent instance.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before$4;
                JavaTemplate before$5;
                JavaTemplate before$6;
                JavaTemplate before$7;
                JavaTemplate before$8;
                JavaTemplate before$9;
                JavaTemplate before$10;
                JavaTemplate before$11;
                JavaTemplate before$12;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.plus(java.time.Duration.ZERO)").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.plus(0, #{temporalUnit:any(java.time.temporal.TemporalUnit)})").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.plusNanos(0)").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.plusMillis(0)").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$4 == null) {
                        this.before$4 = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.plusSeconds(0)").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before$4.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$5 == null) {
                        this.before$5 = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.minus(java.time.Duration.ZERO)").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before$5.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$6 == null) {
                        this.before$6 = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.minus(0, #{temporalUnit:any(java.time.temporal.TemporalUnit)})").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before$6.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$7 == null) {
                        this.before$7 = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.minusNanos(0)").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before$7.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$8 == null) {
                        this.before$8 = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.minusMillis(0)").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before$8.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$9 == null) {
                        this.before$9 = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.minusSeconds(0)").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before$9.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$10 == null) {
                        this.before$10 = JavaTemplate.builder((String)"java.time.Instant.parse(#{instant:any(java.time.Instant)}.toString())").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before$10.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$11 == null) {
                        this.before$11 = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.truncatedTo(java.time.temporal.ChronoUnit.NANOS)").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before$11.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$12 == null) {
                        this.before$12 = JavaTemplate.builder((String)"java.time.Instant.ofEpochSecond(#{instant:any(java.time.Instant)}.getEpochSecond(), #{instant}.getNano())").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before$12.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesType("java.time.temporal.TemporalUnit", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.time.Instant minus(..)", true), new UsesMethod("java.time.Instant minusMillis(..)", true), new UsesMethod("java.time.Instant minusNanos(..)", true), new UsesMethod("java.time.Instant minusSeconds(..)", true), new UsesMethod("java.time.Instant plus(..)", true), new UsesMethod("java.time.Instant plusMillis(..)", true), new UsesMethod("java.time.Instant plusNanos(..)", true), new UsesMethod("java.time.Instant plusSeconds(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.time.Instant getEpochSecond(..)", true), new UsesMethod("java.time.Instant getNano(..)", true), new UsesMethod("java.time.Instant ofEpochSecond(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.time.Instant parse(..)", true), new UsesMethod("java.time.Instant toString(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Instant minus(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Instant plus(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), new UsesMethod("java.time.Instant truncatedTo(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class InstantTruncatedToMillisecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Instant#truncatedTo(TemporalUnit)` over less obvious alternatives";
        }

        public String getDescription() {
            return "Note that `Instant#toEpochMilli()` throws an `ArithmeticException` for dates\n very far in the past or future, while the suggested alternative doesn't.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.time.Instant.ofEpochMilli(#{instant:any(java.time.Instant)}.toEpochMilli())").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.truncatedTo(java.time.temporal.ChronoUnit.MILLIS)").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesMethod("java.time.Instant ofEpochMilli(..)", true), new UsesMethod("java.time.Instant toEpochMilli(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class InstantTruncatedToSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.InstantTruncatedToSeconds`";
        }

        public String getDescription() {
            return "Prefer `Instant#truncatedTo(TemporalUnit)` over less obvious alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.time.Instant.ofEpochSecond(#{instant:any(java.time.Instant)}.getEpochSecond())").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.truncatedTo(java.time.temporal.ChronoUnit.SECONDS)").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesMethod("java.time.Instant getEpochSecond(..)", true), new UsesMethod("java.time.Instant ofEpochSecond(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class InstantAtOffsetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.InstantAtOffset`";
        }

        public String getDescription() {
            return "Prefer `Instant#atOffset(ZoneOffset)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.time.OffsetDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneOffset:any(java.time.ZoneOffset)})").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.atOffset(#{zoneOffset:any(java.time.ZoneOffset)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesType("java.time.ZoneOffset", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime ofInstant(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetTimeOfInstantRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetTimeOfInstant`";
        }

        public String getDescription() {
            return "Prefer `OffsetTime#ofInstant(Instant, ZoneId)` over more indirect alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.time.OffsetDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)}).toOffsetTime()").bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.OffsetDateTime");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.OffsetTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})").bindType("java.time.OffsetTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.atOffset(#{zoneId:any(java.time.ZoneOffset)}).toOffsetTime()").bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.ZoneOffset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.OffsetTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})").bindType("java.time.OffsetTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime toOffsetTime(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesType("java.time.ZoneId", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime ofInstant(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZoneOffset", Boolean.valueOf(true)), new UsesMethod("java.time.Instant atOffset(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class InstantAtZoneRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.InstantAtZone`";
        }

        public String getDescription() {
            return "Prefer `Instant#atZone(ZoneId)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.time.ZonedDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{instant:any(java.time.Instant)}.atZone(#{zoneId:any(java.time.ZoneId)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesType("java.time.ZoneId", Boolean.valueOf(true)), new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime ofInstant(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class UtcClockRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.UtcClock`";
        }

        public String getDescription() {
            return "Use `Clock#systemUTC()` when possible.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.time.Clock.system(java.time.ZoneOffset.UTC)").bindType("java.time.Clock").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.ZoneOffset");
                        this.maybeRemoveImport("java.time.ZoneOffset.UTC");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Clock.systemUTC()").bindType("java.time.Clock").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Clock", Boolean.valueOf(true)), new UsesMethod("java.time.Clock system(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EpochInstantRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.EpochInstant`";
        }

        public String getDescription() {
            return "Prefer `Instant#EPOCH` over alternative representations.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.time.Instant.ofEpochMilli(0)").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Instant.EPOCH").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.time.Instant.ofEpochSecond(0)").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Instant.EPOCH").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.time.Instant.ofEpochSecond(0, 0)").bindType("java.time.Instant").build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Instant.EPOCH").bindType("java.time.Instant").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.time.Instant ofEpochMilli(..)", true), new UsesMethod("java.time.Instant ofEpochSecond(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class InstantIsBeforeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.InstantIsBefore`";
        }

        public String getDescription() {
            return "Prefer `Instant#isBefore(Instant)` over explicit comparison, as it yields more readable code.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{a:any(java.time.Instant)}.compareTo(#{b:any(java.time.Instant)}) < 0").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{a:any(java.time.Instant)}.isBefore(#{b:any(java.time.Instant)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesMethod("java.time.Instant compareTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class InstantIsAfterRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.InstantIsAfter`";
        }

        public String getDescription() {
            return "Prefer `Instant#isBefore(Instant)` over explicit comparison, as it yields more readable code.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{a:any(java.time.Instant)}.compareTo(#{b:any(java.time.Instant)}) > 0").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{a:any(java.time.Instant)}.isAfter(#{b:any(java.time.Instant)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesMethod("java.time.Instant compareTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalTimeMinRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalTimeMin`";
        }

        public String getDescription() {
            return "Prefer the `LocalTime#MIN` over alternative representations.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before$4;
                JavaTemplate before$5;
                JavaTemplate after;

                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.time.LocalTime.MIDNIGHT").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.MIN").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.time.LocalTime.of(0, 0)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.MIN").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.time.LocalTime.of(0, 0, 0)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.MIN").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"java.time.LocalTime.of(0, 0, 0, 0)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.MIN").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$4 == null) {
                        this.before$4 = JavaTemplate.builder((String)"java.time.LocalTime.ofNanoOfDay(0)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$4.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.MIN").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$5 == null) {
                        this.before$5 = JavaTemplate.builder((String)"java.time.LocalTime.ofSecondOfDay(0)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$5.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.MIN").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitFieldAccess(elem, (Object)ctx);
                }

                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.time.LocalTime.MIDNIGHT").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.MIN").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.time.LocalTime.of(0, 0)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.MIN").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.time.LocalTime.of(0, 0, 0)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.MIN").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"java.time.LocalTime.of(0, 0, 0, 0)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.MIN").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$4 == null) {
                        this.before$4 = JavaTemplate.builder((String)"java.time.LocalTime.ofNanoOfDay(0)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$4.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.MIN").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$5 == null) {
                        this.before$5 = JavaTemplate.builder((String)"java.time.LocalTime.ofSecondOfDay(0)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$5.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.MIN").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitIdentifier(elem, (Object)ctx);
                }

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.time.LocalTime.MIDNIGHT").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.MIN").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.time.LocalTime.of(0, 0)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.MIN").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.time.LocalTime.of(0, 0, 0)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.MIN").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"java.time.LocalTime.of(0, 0, 0, 0)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.MIN").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$4 == null) {
                        this.before$4 = JavaTemplate.builder((String)"java.time.LocalTime.ofNanoOfDay(0)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$4.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.MIN").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$5 == null) {
                        this.before$5 = JavaTemplate.builder((String)"java.time.LocalTime.ofSecondOfDay(0)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before$5.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.LocalTime.MIN").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("java.time.LocalTime", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateAtStartOfDayRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateAtStartOfDay`";
        }

        public String getDescription() {
            return "Prefer `LocalDate#atStartOfDay()` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.atTime(java.time.LocalTime.MIN)").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.LocalTime");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.atStartOfDay()").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDate", Boolean.valueOf(true)), new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesType("java.time.LocalTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDate atTime(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ChronoLocalDateIsBeforeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ChronoLocalDateIsBefore`";
        }

        public String getDescription() {
            return "Prefer `ChronoLocalDate#isBefore(ChronoLocalDate)` over explicit comparison, as it yields more readable code.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{a:any(java.time.chrono.ChronoLocalDate)}.compareTo(#{b:any(java.time.chrono.ChronoLocalDate)}) < 0").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{a:any(java.time.chrono.ChronoLocalDate)}.isBefore(#{b:any(java.time.chrono.ChronoLocalDate)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.chrono.ChronoLocalDate", Boolean.valueOf(true)), new UsesMethod("java.time.chrono.ChronoLocalDate compareTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ChronoLocalDateIsAfterRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ChronoLocalDateIsAfter`";
        }

        public String getDescription() {
            return "Prefer `ChronoLocalDate#isBefore(ChronoLocalDate)` over explicit comparison, as it yields more readable code.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{a:any(java.time.chrono.ChronoLocalDate)}.compareTo(#{b:any(java.time.chrono.ChronoLocalDate)}) > 0").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{a:any(java.time.chrono.ChronoLocalDate)}.isAfter(#{b:any(java.time.chrono.ChronoLocalDate)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.chrono.ChronoLocalDate", Boolean.valueOf(true)), new UsesMethod("java.time.chrono.ChronoLocalDate compareTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ChronoLocalDateTimeIsBeforeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ChronoLocalDateTimeIsBefore`";
        }

        public String getDescription() {
            return "Prefer `ChronoLocalDateTime#isBefore(ChronoLocalDateTime)` over explicit comparison, as it yields more readable code.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{a:any(java.time.chrono.ChronoLocalDateTime<?>)}.compareTo(#{b:any(java.time.chrono.ChronoLocalDateTime<?>)}) < 0").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{a:any(java.time.chrono.ChronoLocalDateTime<?>)}.isBefore(#{b:any(java.time.chrono.ChronoLocalDateTime<?>)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.chrono.ChronoLocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.chrono.ChronoLocalDateTime compareTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ChronoLocalDateTimeIsAfterRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ChronoLocalDateTimeIsAfter`";
        }

        public String getDescription() {
            return "Prefer `ChronoLocalDateTime#isBefore(ChronoLocalDateTime)` over explicit comparison, as it yields more readable code.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{a:any(java.time.chrono.ChronoLocalDateTime<?>)}.compareTo(#{b:any(java.time.chrono.ChronoLocalDateTime<?>)}) > 0").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{a:any(java.time.chrono.ChronoLocalDateTime<?>)}.isAfter(#{b:any(java.time.chrono.ChronoLocalDateTime<?>)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.chrono.ChronoLocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.chrono.ChronoLocalDateTime compareTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ChronoZonedDateTimeIsBeforeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ChronoZonedDateTimeIsBefore`";
        }

        public String getDescription() {
            return "Prefer `ChronoZonedDateTime#isBefore(ChronoZonedDateTime)` over explicit comparison, as it yields more readable code.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{a:any(java.time.chrono.ChronoZonedDateTime<?>)}.compareTo(#{b:any(java.time.chrono.ChronoZonedDateTime<?>)}) < 0").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{a:any(java.time.chrono.ChronoZonedDateTime<?>)}.isBefore(#{b:any(java.time.chrono.ChronoZonedDateTime<?>)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.chrono.ChronoZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.chrono.ChronoZonedDateTime compareTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ChronoZonedDateTimeIsAfterRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ChronoZonedDateTimeIsAfter`";
        }

        public String getDescription() {
            return "Prefer `ChronoZonedDateTime#isBefore(ChronoZonedDateTime)` over explicit comparison, as it yields more readable code.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{a:any(java.time.chrono.ChronoZonedDateTime<?>)}.compareTo(#{b:any(java.time.chrono.ChronoZonedDateTime<?>)}) > 0").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{a:any(java.time.chrono.ChronoZonedDateTime<?>)}.isAfter(#{b:any(java.time.chrono.ChronoZonedDateTime<?>)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.chrono.ChronoZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.chrono.ChronoZonedDateTime compareTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimeIsBeforeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimeIsBefore`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#isBefore(OffsetDateTime)` over explicit comparison, as it yields more readable code.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{a:any(java.time.OffsetDateTime)}.compareTo(#{b:any(java.time.OffsetDateTime)}) < 0").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{a:any(java.time.OffsetDateTime)}.isBefore(#{b:any(java.time.OffsetDateTime)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime compareTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimeIsAfterRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimeIsAfter`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#isBefore(OffsetDateTime)` over explicit comparison, as it yields more readable code.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{a:any(java.time.OffsetDateTime)}.compareTo(#{b:any(java.time.OffsetDateTime)}) > 0").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{a:any(java.time.OffsetDateTime)}.isAfter(#{b:any(java.time.OffsetDateTime)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime compareTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ZeroDurationRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ZeroDuration`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZeroDuration {\n    \n    @BeforeTemplate\n    Duration before(TemporalUnit temporalUnit) {\n        return Refaster.anyOf(Duration.ofNanos(0), Duration.ofMillis(0), Duration.ofSeconds(0), Duration.ofSeconds(0, 0), Duration.ofMinutes(0), Duration.ofHours(0), Duration.ofDays(0), Duration.of(0, temporalUnit));\n    }\n    \n    @AfterTemplate\n    Duration after() {\n        return Duration.ZERO;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before$4;
                JavaTemplate before$5;
                JavaTemplate before$6;
                JavaTemplate before$7;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.time.Duration.ofNanos(0)").bindType("java.time.Duration").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Duration.ZERO").bindType("java.time.Duration").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.time.Duration.ofMillis(0)").bindType("java.time.Duration").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Duration.ZERO").bindType("java.time.Duration").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.time.Duration.ofSeconds(0)").bindType("java.time.Duration").build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Duration.ZERO").bindType("java.time.Duration").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"java.time.Duration.ofSeconds(0, 0)").bindType("java.time.Duration").build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Duration.ZERO").bindType("java.time.Duration").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$4 == null) {
                        this.before$4 = JavaTemplate.builder((String)"java.time.Duration.ofMinutes(0)").bindType("java.time.Duration").build();
                    }
                    if ((matcher = this.before$4.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Duration.ZERO").bindType("java.time.Duration").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$5 == null) {
                        this.before$5 = JavaTemplate.builder((String)"java.time.Duration.ofHours(0)").bindType("java.time.Duration").build();
                    }
                    if ((matcher = this.before$5.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Duration.ZERO").bindType("java.time.Duration").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$6 == null) {
                        this.before$6 = JavaTemplate.builder((String)"java.time.Duration.ofDays(0)").bindType("java.time.Duration").build();
                    }
                    if ((matcher = this.before$6.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Duration.ZERO").bindType("java.time.Duration").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$7 == null) {
                        this.before$7 = JavaTemplate.builder((String)"java.time.Duration.of(0, #{temporalUnit:any(java.time.temporal.TemporalUnit)})").bindType("java.time.Duration").build();
                    }
                    if ((matcher = this.before$7.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Duration.ZERO").bindType("java.time.Duration").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.time.temporal.TemporalUnit", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.time.Duration of(..)", true), new UsesMethod("java.time.Duration ofDays(..)", true), new UsesMethod("java.time.Duration ofHours(..)", true), new UsesMethod("java.time.Duration ofMillis(..)", true), new UsesMethod("java.time.Duration ofMinutes(..)", true), new UsesMethod("java.time.Duration ofNanos(..)", true), new UsesMethod("java.time.Duration ofSeconds(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DurationOfDaysRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.DurationOfDays`";
        }

        public String getDescription() {
            return "Prefer `Duration#ofDays(long)` over alternative representations.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.time.Duration.of(#{amount:any(long)}, java.time.temporal.ChronoUnit.DAYS)").bindType("java.time.Duration").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Duration.ofDays(#{amount:any(long)})").bindType("java.time.Duration").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), new UsesMethod("java.time.Duration of(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DurationOfHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.DurationOfHours`";
        }

        public String getDescription() {
            return "Prefer `Duration#ofHours(long)` over alternative representations.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.time.Duration.of(#{amount:any(long)}, java.time.temporal.ChronoUnit.HOURS)").bindType("java.time.Duration").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Duration.ofHours(#{amount:any(long)})").bindType("java.time.Duration").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), new UsesMethod("java.time.Duration of(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DurationOfMillisRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.DurationOfMillis`";
        }

        public String getDescription() {
            return "Prefer `Duration#ofMillis(long)` over alternative representations.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.time.Duration.of(#{amount:any(long)}, java.time.temporal.ChronoUnit.MILLIS)").bindType("java.time.Duration").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Duration.ofMillis(#{amount:any(long)})").bindType("java.time.Duration").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), new UsesMethod("java.time.Duration of(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DurationOfMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.DurationOfMinutes`";
        }

        public String getDescription() {
            return "Prefer `Duration#ofMinutes(long)` over alternative representations.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.time.Duration.of(#{amount:any(long)}, java.time.temporal.ChronoUnit.MINUTES)").bindType("java.time.Duration").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Duration.ofMinutes(#{amount:any(long)})").bindType("java.time.Duration").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), new UsesMethod("java.time.Duration of(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DurationOfNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.DurationOfNanos`";
        }

        public String getDescription() {
            return "Prefer `Duration#ofNanos(long)` over alternative representations.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.time.Duration.of(#{amount:any(long)}, java.time.temporal.ChronoUnit.NANOS)").bindType("java.time.Duration").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Duration.ofNanos(#{amount:any(long)})").bindType("java.time.Duration").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), new UsesMethod("java.time.Duration of(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DurationOfSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.DurationOfSeconds`";
        }

        public String getDescription() {
            return "Prefer `Duration#ofSeconds(long)` over alternative representations.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.time.Duration.of(#{amount:any(long)}, java.time.temporal.ChronoUnit.SECONDS)").bindType("java.time.Duration").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Duration.ofSeconds(#{amount:any(long)})").bindType("java.time.Duration").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), new UsesMethod("java.time.Duration of(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DurationBetweenInstantsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.DurationBetweenInstants`";
        }

        public String getDescription() {
            return "Don't unnecessarily convert to and from milliseconds. (This way nanosecond precision is retained.) <strong>Warning:</strong> this rewrite rule increases precision!.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.time.Duration.ofMillis(#{b:any(java.time.Instant)}.toEpochMilli() - #{a:any(java.time.Instant)}.toEpochMilli())").bindType("java.time.Duration").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Duration.between(#{a:any(java.time.Instant)}, #{b:any(java.time.Instant)})").bindType("java.time.Duration").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMillis(..)", true), new UsesMethod("java.time.Instant toEpochMilli(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DurationBetweenOffsetDateTimesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.DurationBetweenOffsetDateTimes`";
        }

        public String getDescription() {
            return "Don't unnecessarily convert to and from milliseconds. (This way nanosecond precision is retained.) <strong>Warning:</strong> this rewrite rule increases precision!.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.time.Duration.between(#{a:any(java.time.OffsetDateTime)}.toInstant(), #{b:any(java.time.OffsetDateTime)}.toInstant())").bindType("java.time.Duration").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Duration.between(#{a:any(java.time.OffsetDateTime)}, #{b:any(java.time.OffsetDateTime)})").bindType("java.time.Duration").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.time.Duration.ofSeconds(#{b:any(java.time.OffsetDateTime)}.toEpochSecond() - #{a:any(java.time.OffsetDateTime)}.toEpochSecond())").bindType("java.time.Duration").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Duration.between(#{a:any(java.time.OffsetDateTime)}, #{b:any(java.time.OffsetDateTime)})").bindType("java.time.Duration").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.time.Duration between(..)", true), new UsesMethod("java.time.OffsetDateTime toInstant(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.time.Duration ofSeconds(..)", true), new UsesMethod("java.time.OffsetDateTime toEpochSecond(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DurationIsZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.DurationIsZero`";
        }

        public String getDescription() {
            return "Prefer `Duration#isZero()` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{duration:any(java.time.Duration)}.equals(java.time.Duration.ZERO)").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{duration:any(java.time.Duration)}.isZero()").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.time.Duration.ZERO.equals(#{duration:any(java.time.Duration)})").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{duration:any(java.time.Duration)}.isZero()").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration equals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ZeroPeriodRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ZeroPeriod`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZeroPeriod {\n    \n    @BeforeTemplate\n    Period before() {\n        return Refaster.anyOf(Period.ofDays(0), Period.ofWeeks(0), Period.ofMonths(0), Period.ofYears(0), Period.of(0, 0, 0));\n    }\n    \n    @AfterTemplate\n    Period after() {\n        return Period.ZERO;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before$4;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.time.Period.ofDays(0)").bindType("java.time.Period").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Period.ZERO").bindType("java.time.Period").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.time.Period.ofWeeks(0)").bindType("java.time.Period").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Period.ZERO").bindType("java.time.Period").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.time.Period.ofMonths(0)").bindType("java.time.Period").build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Period.ZERO").bindType("java.time.Period").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"java.time.Period.ofYears(0)").bindType("java.time.Period").build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Period.ZERO").bindType("java.time.Period").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$4 == null) {
                        this.before$4 = JavaTemplate.builder((String)"java.time.Period.of(0, 0, 0)").bindType("java.time.Period").build();
                    }
                    if ((matcher = this.before$4.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.time.Period.ZERO").bindType("java.time.Period").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.time.Period of(..)", true), new UsesMethod("java.time.Period ofDays(..)", true), new UsesMethod("java.time.Period ofMonths(..)", true), new UsesMethod("java.time.Period ofWeeks(..)", true), new UsesMethod("java.time.Period ofYears(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDatePlusDaysRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDatePlusDays`";
        }

        public String getDescription() {
            return "Prefer `LocalDate#plusDays(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.plus(java.time.Period.ofDays(#{days:any(int)}))").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.plusDays(#{days:any(int)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.plus(#{days:any(long)}, java.time.temporal.ChronoUnit.DAYS)").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.plusDays(#{days:any(int)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDate", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDate plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofDays(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDatePlusWeeksRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDatePlusWeeks`";
        }

        public String getDescription() {
            return "Prefer `LocalDate#plusWeeks(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.plus(java.time.Period.ofWeeks(#{weeks:any(int)}))").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.plusWeeks(#{weeks:any(int)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.plus(#{weeks:any(long)}, java.time.temporal.ChronoUnit.WEEKS)").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.plusWeeks(#{weeks:any(int)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDate", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDate plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofWeeks(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDatePlusMonthsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDatePlusMonths`";
        }

        public String getDescription() {
            return "Prefer `LocalDate#plusMonths(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.plus(java.time.Period.ofMonths(#{months:any(int)}))").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.plusMonths(#{months:any(int)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.plus(#{months:any(long)}, java.time.temporal.ChronoUnit.MONTHS)").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.plusMonths(#{months:any(int)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDate", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDate plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofMonths(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDatePlusYearsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDatePlusYears`";
        }

        public String getDescription() {
            return "Prefer `LocalDate#plusYears(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.plus(java.time.Period.ofYears(#{years:any(int)}))").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.plusYears(#{years:any(int)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.plus(#{years:any(long)}, java.time.temporal.ChronoUnit.YEARS)").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.plusYears(#{years:any(int)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDate", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDate plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofYears(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateMinusDaysRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateMinusDays`";
        }

        public String getDescription() {
            return "Prefer `LocalDate#minusDays(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.minus(java.time.Period.ofDays(#{days:any(int)}))").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.minusDays(#{days:any(int)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.minus(#{days:any(long)}, java.time.temporal.ChronoUnit.DAYS)").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.minusDays(#{days:any(int)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDate", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDate minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofDays(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateMinusWeeksRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateMinusWeeks`";
        }

        public String getDescription() {
            return "Prefer `LocalDate#minusWeeks(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.minus(java.time.Period.ofWeeks(#{weeks:any(int)}))").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.minusWeeks(#{weeks:any(int)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.minus(#{weeks:any(long)}, java.time.temporal.ChronoUnit.WEEKS)").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.minusWeeks(#{weeks:any(int)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDate", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDate minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofWeeks(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateMinusMonthsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateMinusMonths`";
        }

        public String getDescription() {
            return "Prefer `LocalDate#minusMonths(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.minus(java.time.Period.ofMonths(#{months:any(int)}))").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.minusMonths(#{months:any(int)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.minus(#{months:any(long)}, java.time.temporal.ChronoUnit.MONTHS)").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.minusMonths(#{months:any(int)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDate", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDate minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofMonths(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateMinusYearsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateMinusYears`";
        }

        public String getDescription() {
            return "Prefer `LocalDate#minusYears(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.minus(java.time.Period.ofYears(#{years:any(int)}))").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.minusYears(#{years:any(int)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.minus(#{years:any(long)}, java.time.temporal.ChronoUnit.YEARS)").bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDate:any(java.time.LocalDate)}.minusYears(#{years:any(int)})").bindType("java.time.LocalDate").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDate", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDate minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofYears(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalTimePlusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalTimePlusNanos`";
        }

        public String getDescription() {
            return "Prefer `LocalTime#plusNanos(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.plus(java.time.Duration.ofNanos(#{nanos:any(int)}))").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.plusNanos(#{nanos:any(int)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.plus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.plusNanos(#{nanos:any(int)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalTimePlusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalTimePlusSeconds`";
        }

        public String getDescription() {
            return "Prefer `LocalTime#plusSeconds(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.plus(java.time.Duration.ofSeconds(#{seconds:any(int)}))").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.plusSeconds(#{seconds:any(int)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.plus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.plusSeconds(#{seconds:any(int)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalTimePlusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalTimePlusMinutes`";
        }

        public String getDescription() {
            return "Prefer `LocalTime#plusMinutes(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.plus(java.time.Duration.ofMinutes(#{minutes:any(int)}))").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.plusMinutes(#{minutes:any(int)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.plus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.plusMinutes(#{minutes:any(int)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalTimePlusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalTimePlusHours`";
        }

        public String getDescription() {
            return "Prefer `LocalTime#plusHours(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.plus(java.time.Duration.ofHours(#{hours:any(int)}))").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.plusHours(#{hours:any(int)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.plus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.plusHours(#{hours:any(int)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalTimeMinusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalTimeMinusNanos`";
        }

        public String getDescription() {
            return "Prefer `LocalTime#minusNanos(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.minus(java.time.Duration.ofNanos(#{nanos:any(int)}))").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.minusNanos(#{nanos:any(int)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.minus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.minusNanos(#{nanos:any(int)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalTimeMinusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalTimeMinusSeconds`";
        }

        public String getDescription() {
            return "Prefer `LocalTime#minusSeconds(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.minus(java.time.Duration.ofSeconds(#{seconds:any(int)}))").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.minusSeconds(#{seconds:any(int)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.minus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.minusSeconds(#{seconds:any(int)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalTimeMinusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalTimeMinusMinutes`";
        }

        public String getDescription() {
            return "Prefer `LocalTime#minusMinutes(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.minus(java.time.Duration.ofMinutes(#{minutes:any(int)}))").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.minusMinutes(#{minutes:any(int)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.minus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.minusMinutes(#{minutes:any(int)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalTimeMinusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalTimeMinusHours`";
        }

        public String getDescription() {
            return "Prefer `LocalTime#minusHours(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.minus(java.time.Duration.ofHours(#{hours:any(int)}))").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.minusHours(#{hours:any(int)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.minus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)").bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localTime:any(java.time.LocalTime)}.minusHours(#{hours:any(int)})").bindType("java.time.LocalTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetTimePlusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetTimePlusNanos`";
        }

        public String getDescription() {
            return "Prefer `OffsetTime#plusNanos(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.plus(java.time.Duration.ofNanos(#{nanos:any(int)}))").bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.plusNanos(#{nanos:any(int)})").bindType("java.time.OffsetTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.plus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)").bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.plusNanos(#{nanos:any(int)})").bindType("java.time.OffsetTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetTimePlusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetTimePlusSeconds`";
        }

        public String getDescription() {
            return "Prefer `OffsetTime#plusSeconds(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.plus(java.time.Duration.ofSeconds(#{seconds:any(int)}))").bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.plusSeconds(#{seconds:any(int)})").bindType("java.time.OffsetTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.plus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)").bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.plusSeconds(#{seconds:any(int)})").bindType("java.time.OffsetTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetTimePlusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetTimePlusMinutes`";
        }

        public String getDescription() {
            return "Prefer `OffsetTime#plusMinutes(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.plus(java.time.Duration.ofMinutes(#{minutes:any(int)}))").bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.plusMinutes(#{minutes:any(int)})").bindType("java.time.OffsetTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.plus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)").bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.plusMinutes(#{minutes:any(int)})").bindType("java.time.OffsetTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetTimePlusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetTimePlusHours`";
        }

        public String getDescription() {
            return "Prefer `OffsetTime#plusHours(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.plus(java.time.Duration.ofHours(#{hours:any(int)}))").bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.plusHours(#{hours:any(int)})").bindType("java.time.OffsetTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.plus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)").bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.plusHours(#{hours:any(int)})").bindType("java.time.OffsetTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetTimeMinusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetTimeMinusNanos`";
        }

        public String getDescription() {
            return "Prefer `OffsetTime#minusNanos(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.minus(java.time.Duration.ofNanos(#{nanos:any(int)}))").bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.minusNanos(#{nanos:any(int)})").bindType("java.time.OffsetTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.minus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)").bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.minusNanos(#{nanos:any(int)})").bindType("java.time.OffsetTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetTimeMinusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetTimeMinusSeconds`";
        }

        public String getDescription() {
            return "Prefer `OffsetTime#minusSeconds(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.minus(java.time.Duration.ofSeconds(#{seconds:any(int)}))").bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.minusSeconds(#{seconds:any(int)})").bindType("java.time.OffsetTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.minus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)").bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.minusSeconds(#{seconds:any(int)})").bindType("java.time.OffsetTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetTimeMinusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetTimeMinusMinutes`";
        }

        public String getDescription() {
            return "Prefer `OffsetTime#minusMinutes(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.minus(java.time.Duration.ofMinutes(#{minutes:any(int)}))").bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.minusMinutes(#{minutes:any(int)})").bindType("java.time.OffsetTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.minus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)").bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.minusMinutes(#{minutes:any(int)})").bindType("java.time.OffsetTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetTimeMinusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetTimeMinusHours`";
        }

        public String getDescription() {
            return "Prefer `OffsetTime#minusHours(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.minus(java.time.Duration.ofHours(#{hours:any(int)}))").bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.minusHours(#{hours:any(int)})").bindType("java.time.OffsetTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.minus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)").bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetTime:any(java.time.OffsetTime)}.minusHours(#{hours:any(int)})").bindType("java.time.OffsetTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateTimePlusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateTimePlusNanos`";
        }

        public String getDescription() {
            return "Prefer `LocalDateTime#plusNanos(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plus(java.time.Duration.ofNanos(#{nanos:any(int)}))").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plusNanos(#{nanos:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plusNanos(#{nanos:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateTimePlusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateTimePlusSeconds`";
        }

        public String getDescription() {
            return "Prefer `LocalDateTime#plusSeconds(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plus(java.time.Duration.ofSeconds(#{seconds:any(int)}))").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plusSeconds(#{seconds:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plusSeconds(#{seconds:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateTimePlusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateTimePlusMinutes`";
        }

        public String getDescription() {
            return "Prefer `LocalDateTime#plusMinutes(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plus(java.time.Duration.ofMinutes(#{minutes:any(int)}))").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plusMinutes(#{minutes:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plusMinutes(#{minutes:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateTimePlusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateTimePlusHours`";
        }

        public String getDescription() {
            return "Prefer `LocalDateTime#plusHours(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plus(java.time.Duration.ofHours(#{hours:any(int)}))").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plusHours(#{hours:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plusHours(#{hours:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateTimePlusDaysRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateTimePlusDays`";
        }

        public String getDescription() {
            return "Prefer `LocalDateTime#plusDays(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plus(java.time.Period.ofDays(#{days:any(int)}))").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plusDays(#{days:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plus(#{days:any(long)}, java.time.temporal.ChronoUnit.DAYS)").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plusDays(#{days:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofDays(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateTimePlusWeeksRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateTimePlusWeeks`";
        }

        public String getDescription() {
            return "Prefer `LocalDateTime#plusWeeks(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plus(java.time.Period.ofWeeks(#{weeks:any(int)}))").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plusWeeks(#{weeks:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plus(#{weeks:any(long)}, java.time.temporal.ChronoUnit.WEEKS)").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plusWeeks(#{weeks:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofWeeks(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateTimePlusMonthsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateTimePlusMonths`";
        }

        public String getDescription() {
            return "Prefer `LocalDateTime#plusMonths(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plus(java.time.Period.ofMonths(#{months:any(int)}))").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plusMonths(#{months:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plus(#{months:any(long)}, java.time.temporal.ChronoUnit.MONTHS)").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plusMonths(#{months:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofMonths(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateTimePlusYearsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateTimePlusYears`";
        }

        public String getDescription() {
            return "Prefer `LocalDateTime#plusYears(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plus(java.time.Period.ofYears(#{years:any(int)}))").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plusYears(#{years:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plus(#{years:any(long)}, java.time.temporal.ChronoUnit.YEARS)").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.plusYears(#{years:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofYears(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateTimeMinusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateTimeMinusNanos`";
        }

        public String getDescription() {
            return "Prefer `LocalDateTime#minusNanos(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minus(java.time.Duration.ofNanos(#{nanos:any(int)}))").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minusNanos(#{nanos:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minusNanos(#{nanos:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateTimeMinusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateTimeMinusSeconds`";
        }

        public String getDescription() {
            return "Prefer `LocalDateTime#minusSeconds(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minus(java.time.Duration.ofSeconds(#{seconds:any(int)}))").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minusSeconds(#{seconds:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minusSeconds(#{seconds:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateTimeMinusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateTimeMinusMinutes`";
        }

        public String getDescription() {
            return "Prefer `LocalDateTime#minusMinutes(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minus(java.time.Duration.ofMinutes(#{minutes:any(int)}))").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minusMinutes(#{minutes:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minusMinutes(#{minutes:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateTimeMinusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateTimeMinusHours`";
        }

        public String getDescription() {
            return "Prefer `LocalDateTime#minusHours(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minus(java.time.Duration.ofHours(#{hours:any(int)}))").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minusHours(#{hours:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minusHours(#{hours:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateTimeMinusDaysRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateTimeMinusDays`";
        }

        public String getDescription() {
            return "Prefer `LocalDateTime#minusDays(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minus(java.time.Period.ofDays(#{days:any(int)}))").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minusDays(#{days:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minus(#{days:any(long)}, java.time.temporal.ChronoUnit.DAYS)").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minusDays(#{days:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofDays(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateTimeMinusWeeksRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateTimeMinusWeeks`";
        }

        public String getDescription() {
            return "Prefer `LocalDateTime#minusWeeks(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minus(java.time.Period.ofWeeks(#{weeks:any(int)}))").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minusWeeks(#{weeks:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minus(#{weeks:any(long)}, java.time.temporal.ChronoUnit.WEEKS)").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minusWeeks(#{weeks:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofWeeks(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateTimeMinusMonthsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateTimeMinusMonths`";
        }

        public String getDescription() {
            return "Prefer `LocalDateTime#minusMonths(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minus(java.time.Period.ofMonths(#{months:any(int)}))").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minusMonths(#{months:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minus(#{months:any(long)}, java.time.temporal.ChronoUnit.MONTHS)").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minusMonths(#{months:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofMonths(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalDateTimeMinusYearsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.LocalDateTimeMinusYears`";
        }

        public String getDescription() {
            return "Prefer `LocalDateTime#minusYears(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minus(java.time.Period.ofYears(#{years:any(int)}))").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minusYears(#{years:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minus(#{years:any(long)}, java.time.temporal.ChronoUnit.YEARS)").bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{localDateTime:any(java.time.LocalDateTime)}.minusYears(#{years:any(int)})").bindType("java.time.LocalDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofYears(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimePlusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimePlusNanos`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#plusNanos(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(java.time.Duration.ofNanos(#{nanos:any(int)}))").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plusNanos(#{nanos:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plusNanos(#{nanos:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimePlusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimePlusSeconds`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#plusSeconds(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(java.time.Duration.ofSeconds(#{seconds:any(int)}))").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plusSeconds(#{seconds:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plusSeconds(#{seconds:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimePlusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimePlusMinutes`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#plusMinutes(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(java.time.Duration.ofMinutes(#{minutes:any(int)}))").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plusMinutes(#{minutes:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plusMinutes(#{minutes:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimePlusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimePlusHours`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#plusHours(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(java.time.Duration.ofHours(#{hours:any(int)}))").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plusHours(#{hours:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plusHours(#{hours:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimePlusDaysRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimePlusDays`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#plusDays(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(java.time.Period.ofDays(#{days:any(int)}))").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plusDays(#{days:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(#{days:any(long)}, java.time.temporal.ChronoUnit.DAYS)").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plusDays(#{days:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofDays(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimePlusWeeksRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimePlusWeeks`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#plusWeeks(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(java.time.Period.ofWeeks(#{weeks:any(int)}))").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plusWeeks(#{weeks:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(#{weeks:any(long)}, java.time.temporal.ChronoUnit.WEEKS)").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plusWeeks(#{weeks:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofWeeks(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimePlusMonthsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimePlusMonths`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#plusMonths(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(java.time.Period.ofMonths(#{months:any(int)}))").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plusMonths(#{months:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(#{months:any(long)}, java.time.temporal.ChronoUnit.MONTHS)").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plusMonths(#{months:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofMonths(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimePlusYearsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimePlusYears`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#plusYears(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(java.time.Period.ofYears(#{years:any(int)}))").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plusYears(#{years:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(#{years:any(long)}, java.time.temporal.ChronoUnit.YEARS)").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.plusYears(#{years:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofYears(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimeMinusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimeMinusNanos`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#minusNanos(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(java.time.Duration.ofNanos(#{nanos:any(int)}))").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minusNanos(#{nanos:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minusNanos(#{nanos:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimeMinusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimeMinusSeconds`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#minusSeconds(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(java.time.Duration.ofSeconds(#{seconds:any(int)}))").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minusSeconds(#{seconds:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minusSeconds(#{seconds:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimeMinusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimeMinusMinutes`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#minusMinutes(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(java.time.Duration.ofMinutes(#{minutes:any(int)}))").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minusMinutes(#{minutes:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minusMinutes(#{minutes:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimeMinusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimeMinusHours`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#minusHours(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(java.time.Duration.ofHours(#{hours:any(int)}))").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minusHours(#{hours:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minusHours(#{hours:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimeMinusDaysRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimeMinusDays`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#minusDays(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(java.time.Period.ofDays(#{days:any(int)}))").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minusDays(#{days:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(#{days:any(long)}, java.time.temporal.ChronoUnit.DAYS)").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minusDays(#{days:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofDays(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimeMinusWeeksRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimeMinusWeeks`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#minusWeeks(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(java.time.Period.ofWeeks(#{weeks:any(int)}))").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minusWeeks(#{weeks:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(#{weeks:any(long)}, java.time.temporal.ChronoUnit.WEEKS)").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minusWeeks(#{weeks:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofWeeks(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimeMinusMonthsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimeMinusMonths`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#minusMonths(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(java.time.Period.ofMonths(#{months:any(int)}))").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minusMonths(#{months:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(#{months:any(long)}, java.time.temporal.ChronoUnit.MONTHS)").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minusMonths(#{months:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofMonths(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OffsetDateTimeMinusYearsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.OffsetDateTimeMinusYears`";
        }

        public String getDescription() {
            return "Prefer `OffsetDateTime#minusYears(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(java.time.Period.ofYears(#{years:any(int)}))").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minusYears(#{years:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(#{years:any(long)}, java.time.temporal.ChronoUnit.YEARS)").bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{offsetDateTime:any(java.time.OffsetDateTime)}.minusYears(#{years:any(int)})").bindType("java.time.OffsetDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofYears(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ZonedDateTimePlusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ZonedDateTimePlusNanos`";
        }

        public String getDescription() {
            return "Prefer `ZonedDateTime#plusNanos(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(java.time.Duration.ofNanos(#{nanos:any(int)}))").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plusNanos(#{nanos:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plusNanos(#{nanos:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ZonedDateTimePlusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ZonedDateTimePlusSeconds`";
        }

        public String getDescription() {
            return "Prefer `ZonedDateTime#plusSeconds(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(java.time.Duration.ofSeconds(#{seconds:any(int)}))").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plusSeconds(#{seconds:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plusSeconds(#{seconds:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ZonedDateTimePlusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ZonedDateTimePlusMinutes`";
        }

        public String getDescription() {
            return "Prefer `ZonedDateTime#plusMinutes(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(java.time.Duration.ofMinutes(#{minutes:any(int)}))").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plusMinutes(#{minutes:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plusMinutes(#{minutes:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ZonedDateTimePlusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ZonedDateTimePlusHours`";
        }

        public String getDescription() {
            return "Prefer `ZonedDateTime#plusHours(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(java.time.Duration.ofHours(#{hours:any(int)}))").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plusHours(#{hours:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plusHours(#{hours:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ZonedDateTimePlusDaysRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ZonedDateTimePlusDays`";
        }

        public String getDescription() {
            return "Prefer `ZonedDateTime#plusDays(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(java.time.Period.ofDays(#{days:any(int)}))").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plusDays(#{days:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(#{days:any(long)}, java.time.temporal.ChronoUnit.DAYS)").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plusDays(#{days:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofDays(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ZonedDateTimePlusWeeksRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ZonedDateTimePlusWeeks`";
        }

        public String getDescription() {
            return "Prefer `ZonedDateTime#plusWeeks(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(java.time.Period.ofWeeks(#{weeks:any(int)}))").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plusWeeks(#{weeks:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(#{weeks:any(long)}, java.time.temporal.ChronoUnit.WEEKS)").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plusWeeks(#{weeks:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofWeeks(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ZonedDateTimePlusMonthsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ZonedDateTimePlusMonths`";
        }

        public String getDescription() {
            return "Prefer `ZonedDateTime#plusMonths(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(java.time.Period.ofMonths(#{months:any(int)}))").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plusMonths(#{months:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(#{months:any(long)}, java.time.temporal.ChronoUnit.MONTHS)").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plusMonths(#{months:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofMonths(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ZonedDateTimePlusYearsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ZonedDateTimePlusYears`";
        }

        public String getDescription() {
            return "Prefer `ZonedDateTime#plusYears(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(java.time.Period.ofYears(#{years:any(int)}))").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plusYears(#{years:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(#{years:any(long)}, java.time.temporal.ChronoUnit.YEARS)").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.plusYears(#{years:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime plus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofYears(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ZonedDateTimeMinusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ZonedDateTimeMinusNanos`";
        }

        public String getDescription() {
            return "Prefer `ZonedDateTime#minusNanos(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(java.time.Duration.ofNanos(#{nanos:any(int)}))").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minusNanos(#{nanos:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minusNanos(#{nanos:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ZonedDateTimeMinusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ZonedDateTimeMinusSeconds`";
        }

        public String getDescription() {
            return "Prefer `ZonedDateTime#minusSeconds(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(java.time.Duration.ofSeconds(#{seconds:any(int)}))").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minusSeconds(#{seconds:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minusSeconds(#{seconds:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ZonedDateTimeMinusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ZonedDateTimeMinusMinutes`";
        }

        public String getDescription() {
            return "Prefer `ZonedDateTime#minusMinutes(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(java.time.Duration.ofMinutes(#{minutes:any(int)}))").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minusMinutes(#{minutes:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minusMinutes(#{minutes:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ZonedDateTimeMinusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ZonedDateTimeMinusHours`";
        }

        public String getDescription() {
            return "Prefer `ZonedDateTime#minusHours(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(java.time.Duration.ofHours(#{hours:any(int)}))").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minusHours(#{hours:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minusHours(#{hours:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ZonedDateTimeMinusDaysRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ZonedDateTimeMinusDays`";
        }

        public String getDescription() {
            return "Prefer `ZonedDateTime#minusDays(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(java.time.Period.ofDays(#{days:any(int)}))").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minusDays(#{days:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(#{days:any(long)}, java.time.temporal.ChronoUnit.DAYS)").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minusDays(#{days:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofDays(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ZonedDateTimeMinusWeeksRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ZonedDateTimeMinusWeeks`";
        }

        public String getDescription() {
            return "Prefer `ZonedDateTime#minusWeeks(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(java.time.Period.ofWeeks(#{weeks:any(int)}))").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minusWeeks(#{weeks:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(#{weeks:any(long)}, java.time.temporal.ChronoUnit.WEEKS)").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minusWeeks(#{weeks:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofWeeks(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ZonedDateTimeMinusMonthsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ZonedDateTimeMinusMonths`";
        }

        public String getDescription() {
            return "Prefer `ZonedDateTime#minusMonths(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(java.time.Period.ofMonths(#{months:any(int)}))").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minusMonths(#{months:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(#{months:any(long)}, java.time.temporal.ChronoUnit.MONTHS)").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minusMonths(#{months:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofMonths(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ZonedDateTimeMinusYearsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TimeRules.ZonedDateTimeMinusYears`";
        }

        public String getDescription() {
            return "Prefer `ZonedDateTime#minusYears(long)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(java.time.Period.ofYears(#{years:any(int)}))").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.Period");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minusYears(#{years:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(#{years:any(long)}, java.time.temporal.ChronoUnit.YEARS)").bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{zonedDateTime:any(java.time.ZonedDateTime)}.minusYears(#{years:any(int)})").bindType("java.time.ZonedDateTime").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime minus(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofYears(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }
}

