/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class InputStreamRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`InputStreamRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `InputStream`s.\n[Source](https://error-prone.picnic.tech/refasterrules/InputStreamRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new InputStreamTransferToRecipe(), new InputStreamReadAllBytesRecipe(), new InputStreamReadNBytesRecipe(), new InputStreamSkipNBytesRecipe()});
    }

    @NullMarked
    public static class InputStreamTransferToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `InputStreamRules.InputStreamTransferTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class InputStreamTransferTo {\n    \n    @BeforeTemplate\n    long before(InputStream in, OutputStream out) throws IOException {\n        return ByteStreams.copy(in, out);\n    }\n    \n    @AfterTemplate\n    long after(InputStream in, OutputStream out) throws IOException {\n        return in.transferTo(out);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.io.ByteStreams.copy(#{in:any(java.io.InputStream)}, #{out:any(java.io.OutputStream)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.io.ByteStreams");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{in:any(java.io.InputStream)}.transferTo(#{out:any(java.io.OutputStream)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.io.ByteStreams", Boolean.valueOf(true)), new UsesType("java.io.InputStream", Boolean.valueOf(true)), new UsesType("java.io.OutputStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.io.ByteStreams copy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class InputStreamReadAllBytesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `InputStreamRules.InputStreamReadAllBytes`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class InputStreamReadAllBytes {\n    \n    @BeforeTemplate\n    byte[] before(InputStream in) throws IOException {\n        return ByteStreams.toByteArray(in);\n    }\n    \n    @AfterTemplate\n    byte[] after(InputStream in) throws IOException {\n        return in.readAllBytes();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.io.ByteStreams.toByteArray(#{in:any(java.io.InputStream)})").bindType("byte[]").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.io.ByteStreams");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{in:any(java.io.InputStream)}.readAllBytes()").bindType("byte[]").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.io.ByteStreams", Boolean.valueOf(true)), new UsesType("java.io.InputStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.io.ByteStreams toByteArray(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class InputStreamReadNBytesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `InputStreamRules.InputStreamReadNBytes`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class InputStreamReadNBytes {\n    \n    @BeforeTemplate\n    byte[] before(InputStream in, int n) throws IOException {\n        return ByteStreams.limit(in, n).readAllBytes();\n    }\n    \n    @AfterTemplate\n    byte[] after(InputStream in, int n) throws IOException {\n        return in.readNBytes(n);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.io.ByteStreams.limit(#{in:any(java.io.InputStream)}, #{n:any(int)}).readAllBytes()").bindType("byte[]").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.io.ByteStreams");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{in:any(java.io.InputStream)}.readNBytes(#{n:any(int)})").bindType("byte[]").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.io.ByteStreams", Boolean.valueOf(true)), new UsesType("java.io.InputStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.io.ByteStreams limit(..)", true), new UsesMethod("java.io.InputStream readAllBytes(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class InputStreamSkipNBytesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `InputStreamRules.InputStreamSkipNBytes`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class InputStreamSkipNBytes {\n    \n    @BeforeTemplate\n    void before(InputStream in, long n) throws IOException {\n        ByteStreams.skipFully(in, n);\n    }\n    \n    @AfterTemplate\n    void after(InputStream in, long n) throws IOException {\n        in.skipNBytes(n);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.io.ByteStreams.skipFully(#{in:any(java.io.InputStream)}, #{n:any(long)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.io.ByteStreams");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{in:any(java.io.InputStream)}.skipNBytes(#{n:any(long)});").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.io.ByteStreams", Boolean.valueOf(true)), new UsesType("java.io.InputStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.io.ByteStreams skipFully(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

