/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.upgrade;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.upgrade.AbstractCamelJavaVisitor;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.tree.Xml;
import org.openrewrite.yaml.tree.Yaml;

public class RecipesUtil {
    private static Pattern kebabCasePattern = Pattern.compile("-(.)");

    public static TreeVisitor<?, ExecutionContext> newVisitor(AbstractCamelJavaVisitor visitor) {
        return Preconditions.check((TreeVisitor)new UsesType("org.apache.camel..*", Boolean.valueOf(false)), (TreeVisitor)visitor);
    }

    public static TreeVisitor<?, ExecutionContext> newVisitor(String requiredImport, AbstractCamelJavaVisitor visitor) {
        return Preconditions.check((TreeVisitor)new UsesType(requiredImport, Boolean.valueOf(false)), (TreeVisitor)visitor);
    }

    public static J.Annotation createAnnotation(J.Annotation annotation, String name, Function<String, Boolean> argMatcher, String args) {
        LinkedList<J.Empty> originalArguments = annotation.getArguments() == null ? new LinkedList<J.Empty>() : new LinkedList(annotation.getArguments());
        String newArgName = args.replaceAll("=.*", "").trim();
        if (argMatcher == null) {
            originalArguments.add(new J.Empty(Tree.randomId(), Space.format((String)args), Markers.EMPTY));
        } else {
            ListIterator<J.Empty> iter = originalArguments.listIterator();
            while (iter.hasNext()) {
                Expression expr = (Expression)iter.next();
                if (!argMatcher.apply(expr.toString().replaceAll("\\s", "")).booleanValue()) continue;
                iter.set(new J.Empty(Tree.randomId(), Space.format((String)args), Markers.EMPTY));
            }
        }
        LinkedList<JRightPadded> newArgs = new LinkedList<JRightPadded>();
        for (Expression expression : originalArguments) {
            newArgs.add(new JRightPadded((Object)expression, Space.EMPTY, Markers.EMPTY));
        }
        J.Identifier newAnnotationIdentifier = new J.Identifier(Tree.randomId(), annotation.getPrefix(), Markers.EMPTY, Collections.emptyList(), name, (JavaType)JavaType.ShallowClass.build((String)"java.lang.Object"), null);
        JContainer jContainer = JContainer.build((Space)Space.EMPTY, newArgs, (Markers)Markers.EMPTY);
        return new J.Annotation(UUID.randomUUID(), annotation.getPrefix(), Markers.EMPTY, (NameTree)newAnnotationIdentifier, jContainer);
    }

    public static Optional<String> getValueOfArgs(List<Expression> expressions, String parameter) {
        if (expressions == null || expressions.isEmpty()) {
            return Optional.empty();
        }
        return expressions.stream().filter(e -> e.toString().replaceAll("\\s", "").startsWith(parameter + "=")).map(e -> e.toString().replaceAll("\\s", "").replaceFirst(parameter + "=", "")).findFirst();
    }

    public static boolean methodInvocationAreArgumentEmpty(J.MethodInvocation mi) {
        return mi.getArguments().stream().filter(e -> !(e instanceof J.Empty)).findAny().isEmpty();
    }

    public static Comment createMultinlineComment(String text) {
        return new TextComment(true, text, null, Markers.EMPTY);
    }

    public static Comment createComment(String text) {
        return new TextComment(false, text, null, Markers.EMPTY);
    }

    public static Xml.Comment createXmlComment(String text) {
        return new Xml.Comment(UUID.randomUUID(), null, Markers.EMPTY, text);
    }

    public static boolean isCommentBeforeElement(J element, String comment) {
        return element != null && element.getPrefix() != null && element.getPrefix().getComments() != null && !element.getPrefix().getComments().isEmpty() && element.getPrefix().getComments().stream().filter(c -> c instanceof TextComment && comment.equals(((TextComment)c).getText())).findAny().isPresent();
    }

    public static J createTypeCast(Object type, Expression arg) {
        return new J.TypeCast(Tree.randomId(), Space.EMPTY, Markers.EMPTY, RecipesUtil.createParentheses(type), arg);
    }

    public static <T> J.ControlParentheses createParentheses(T t) {
        return new J.ControlParentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, RecipesUtil.padRight(t));
    }

    public static J.Identifier createIdentifier(Space prefix, String name, String type) {
        return new J.Identifier(Tree.randomId(), prefix, Markers.EMPTY, Collections.emptyList(), name, (JavaType)JavaType.ShallowClass.build((String)type), null);
    }

    public static Expression createNullExpression() {
        return new J.Literal(UUID.randomUUID(), Space.SINGLE_SPACE, Markers.EMPTY, null, "null", null, JavaType.Primitive.Null);
    }

    public static J.Literal createStringLiteral(String value) {
        return new J.Literal(UUID.randomUUID(), Space.EMPTY, Markers.EMPTY, (Object)value, "\"" + value + "\"", null, JavaType.Primitive.String);
    }

    private static <T> JRightPadded<T> padRight(T tree) {
        return new JRightPadded(tree, Space.EMPTY, Markers.EMPTY);
    }

    public static String getProperty(Cursor cursor) {
        StringBuilder asProperty = new StringBuilder();
        Iterator path = cursor.getPath();
        int i = 0;
        while (path.hasNext()) {
            Object next = path.next();
            if (next instanceof Yaml.Mapping.Entry) {
                Yaml.Mapping.Entry entry = (Yaml.Mapping.Entry)next;
                if (i++ > 0) {
                    asProperty.insert(0, '.');
                }
                asProperty.insert(0, entry.getKey().getValue());
            }
            if (!(next instanceof Xml.Tag)) continue;
            Xml.Tag t = (Xml.Tag)next;
            if (i++ > 0) {
                asProperty.insert(0, '/');
            }
            asProperty.insert(0, t.getName());
        }
        return asProperty.toString();
    }

    public static String kebabCaseToCamelCase(String kebabCase) {
        return kebabCasePattern.matcher(kebabCase).replaceAll(mr -> mr.group(1).toUpperCase());
    }

    public static @Nullable String getValueFromScalar(Yaml y) {
        if (y instanceof Yaml.Scalar) {
            return ((Yaml.Scalar)y).getValue();
        }
        return null;
    }

    public static @Nullable String replacePropertyInUrl(String uri, String component, String oldProperty, String newProperty, String optionalValuePrefix) {
        if (uri.startsWith(component) && uri.contains(oldProperty)) {
            if (optionalValuePrefix != null) {
                Matcher m = Pattern.compile(String.format("(^%s[:?].*)%s=(['\"]?.+$)", component, oldProperty)).matcher(uri);
                if (m.find()) {
                    return m.group(1) + newProperty + "=" + optionalValuePrefix + m.group(2);
                }
            } else {
                throw new IllegalArgumentException("Replace without prefix is not implemented yet!");
            }
        }
        return null;
    }

    public static enum Category {
        DATAMINING("datamining"),
        AI("ai"),
        API("api"),
        AZURE("azure"),
        BATCH("batch"),
        BIGDATA("bigdata"),
        BITCOIN("bitcoin"),
        BLOCKCHAIN("blockchain"),
        CACHE("cache"),
        CHAT("chat"),
        CLOUD("cloud"),
        CLUSTERING("clustering"),
        CMS("cms"),
        COMPUTE("compute"),
        COMPUTING("computing"),
        CONTAINER("container"),
        CORE("core"),
        CRM("crm"),
        DATA("data"),
        DATABASE("database"),
        DATAGRID("datagrid"),
        DEEPLEARNING("deeplearning"),
        DEPLOYMENT("deployment"),
        DOCUMENT("document"),
        ENDPOINT("endpoint"),
        ENGINE("engine"),
        EVENTBUS("eventbus"),
        FILE("file"),
        HADOOP("hadoop"),
        HCM("hcm"),
        HL7("hl7"),
        HTTP("http"),
        IOT("iot"),
        IPFS("ipfs"),
        JAVA("java"),
        LDAP("ldap"),
        LEDGER("ledger"),
        LOCATION("location"),
        LOG("log"),
        MAIL("mail"),
        MANAGEMENT("management"),
        MESSAGING("messaging"),
        MLLP("mllp"),
        MOBILE("mobile"),
        MONITORING("monitoring"),
        NETWORKING("networking"),
        NOSQL("nosql"),
        OPENAPI("openapi"),
        PAAS("paas"),
        PAYMENT("payment"),
        PLANNING("planning"),
        PRINTING("printing"),
        PROCESS("process"),
        QUEUE("queue"),
        REACTIVE("reactive"),
        REPORTING("reporting"),
        REST("rest"),
        RPC("rpc"),
        RSS("rss"),
        SAP("sap"),
        SCHEDULING("scheduling"),
        SCRIPT("script"),
        SEARCH("search"),
        SECURITY("security"),
        SERVERLESS("serverless"),
        SHEETS("sheets"),
        SOAP("soap"),
        SOCIAL("social"),
        SPRING("spring"),
        SQL("sql"),
        STREAMS("streams"),
        SUPPORT("support"),
        SWAGGER("swagger"),
        SYSTEM("system"),
        TCP("tcp"),
        TESTING("testing"),
        TRANSFORMATION("transformation"),
        UDP("udp"),
        VALIDATION("validation"),
        VOIP("voip"),
        WEBSERVICE("webservice"),
        WEBSOCKET("websocket"),
        WORKFLOW("workflow");

        private final String value;

        private Category(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

