/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.weblogic.rewrite.jakarta;

import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.ExecutionContext;
import org.openrewrite.NlsRewrite;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class ChangeJakartaFacesMethodCalls
extends Recipe {
    private static final String GET_EXPRESSION_FACTORY_METHOD_NAME = "getExpressionFactory";
    private static final String CREATE_VALUE_EXPRESSION_METHOD_NAME = "createValueExpression";
    private static final String GET_EL_CONTEXT_METHOD_CALL = "FacesContext.getCurrentInstance().getELContext()";
    private static final MethodMatcher createValueBindingMatcher = new MethodMatcher("*.faces.application.Application createValueBinding(java.lang.String)");
    private static final MethodMatcher getValueMatcher = new MethodMatcher("jakarta.el.ValueExpression getValue(jakarta.faces.context.FacesContext)");
    private static final Pattern VALUE_EXPRESSION_PATTERN = Pattern.compile("jakarta.el.ValueExpression");
    private static final Pattern FACES_CONTEXT_PATTERN = Pattern.compile("jakarta.faces.context.FacesContext");

    @NlsRewrite.DisplayName
    @NotNull
    public String getDisplayName() {
        return "ChangeJakartaFacesMethodCalls";
    }

    @NlsRewrite.Description
    @NotNull
    public String getDescription() {
        return "Handle method call changes for deprecated Faces/EL methods with different arguments from the original.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodCall, ExecutionContext ctx) {
                J.MethodInvocation m = methodCall;
                if (createValueBindingMatcher.matches((MethodCall)methodCall)) {
                    m = this.replaceCreateValueBinding(methodCall);
                } else if (ChangeJakartaFacesMethodCalls.this.isGetValueMethod(methodCall)) {
                    m = this.changeGetValueArgument(methodCall);
                }
                return super.visitMethodInvocation(m, (Object)ctx);
            }

            private J.MethodInvocation changeGetValueArgument(J.MethodInvocation methodCall) {
                J.Identifier objectIdentifier = (J.Identifier)methodCall.getSelect();
                if (objectIdentifier == null) {
                    return methodCall;
                }
                Expression firstArg = (Expression)methodCall.getArguments().get(0);
                if (firstArg.getType() != null && firstArg.getType().isAssignableFrom(FACES_CONTEXT_PATTERN)) {
                    String newArg = String.valueOf(methodCall.getArguments().get(0)) + ".getELContext()";
                    String newGetValueTemplateStr = String.format("%s.%s(%s)", objectIdentifier.getSimpleName(), methodCall.getSimpleName(), newArg);
                    JavaTemplate newGetValueTemplate = JavaTemplate.builder((String)newGetValueTemplateStr).build();
                    return (J.MethodInvocation)newGetValueTemplate.apply(this.getCursor(), methodCall.getCoordinates().replace(), new Object[0]);
                }
                return methodCall;
            }

            private J.MethodInvocation replaceCreateValueBinding(J.MethodInvocation methodCall) {
                J.Identifier objectIdentifier = (J.Identifier)methodCall.getSelect();
                if (objectIdentifier == null) {
                    return methodCall;
                }
                String newMethodCallTemplate = String.format("%s.%s().%s(%s, #{any(java.lang.String)}, Object.class)", objectIdentifier.getSimpleName(), ChangeJakartaFacesMethodCalls.GET_EXPRESSION_FACTORY_METHOD_NAME, ChangeJakartaFacesMethodCalls.CREATE_VALUE_EXPRESSION_METHOD_NAME, ChangeJakartaFacesMethodCalls.GET_EL_CONTEXT_METHOD_CALL);
                JavaTemplate createValueExpressionTemplate = JavaTemplate.builder((String)newMethodCallTemplate).imports(new String[]{"jakarta.faces.context.FacesContext"}).build();
                return (J.MethodInvocation)createValueExpressionTemplate.apply(this.getCursor(), methodCall.getCoordinates().replace(), new Object[]{methodCall.getArguments().get(0)});
            }
        };
    }

    private boolean isGetValueMethod(J.MethodInvocation methodCall) {
        if (methodCall.getMethodType() != null) {
            return getValueMatcher.matches((MethodCall)methodCall);
        }
        Expression objForMethodCall = methodCall.getSelect();
        return objForMethodCall != null && objForMethodCall.getType() != null && objForMethodCall.getType().isAssignableFrom(VALUE_EXPRESSION_PATTERN) && methodCall.getArguments().size() == 1 && ((Expression)methodCall.getArguments().get(0)).getType() != null && ((Expression)methodCall.getArguments().get(0)).getType().isAssignableFrom(FACES_CONTEXT_PATTERN);
    }

    @Generated
    public ChangeJakartaFacesMethodCalls() {
    }

    @Generated
    public String toString() {
        return "ChangeJakartaFacesMethodCalls()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeJakartaFacesMethodCalls)) {
            return false;
        }
        ChangeJakartaFacesMethodCalls other = (ChangeJakartaFacesMethodCalls)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeJakartaFacesMethodCalls;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

