/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.api.AbstractVersionDetails;
import org.codehaus.mojo.versions.api.ArtifactAssociation;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.Property;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.ordering.BoundArtifactVersion;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.utils.ArtifactVersionService;

public class PropertyVersions
extends AbstractVersionDetails {
    private final String name;
    private final String profileId;
    private final Set<ArtifactAssociation> associations;
    private final SortedSet<ArtifactVersion> resolvedVersions;
    private final Log log;

    PropertyVersions(String profileId, String name, Log log, Set<ArtifactAssociation> associations, SortedSet<ArtifactVersion> resolvedVersions) {
        this.profileId = profileId;
        this.name = name;
        this.log = log;
        this.associations = new TreeSet<ArtifactAssociation>(associations);
        this.resolvedVersions = resolvedVersions;
    }

    public ArtifactAssociation[] getAssociations() {
        return this.associations.toArray(new ArtifactAssociation[0]);
    }

    public ArtifactVersion[] getVersions(Collection<Artifact> artifacts) {
        TreeSet<ArtifactVersion> result = new TreeSet<ArtifactVersion>();
        for (ArtifactAssociation association : this.associations) {
            for (Artifact artifact : artifacts) {
                if (!association.getArtifact().getGroupId().equals(artifact.getGroupId()) || !association.getArtifact().getArtifactId().equals(artifact.getArtifactId())) continue;
                try {
                    result.add(artifact.getSelectedVersion());
                }
                catch (OverConstrainedVersionException overConstrainedVersionException) {}
            }
        }
        result.removeIf(candidate -> this.associations.stream().anyMatch(association -> artifacts.stream().noneMatch(artifact -> {
            try {
                return association.getArtifact().getGroupId().equals(artifact.getGroupId()) && association.getArtifact().getArtifactId().equals(artifact.getArtifactId()) && candidate.toString().equals(artifact.getSelectedVersion().toString());
            }
            catch (OverConstrainedVersionException e) {
                return false;
            }
        })));
        return result.toArray(new ArtifactVersion[0]);
    }

    @Override
    public ArtifactVersion[] getVersions(boolean includeSnapshots) {
        return (ArtifactVersion[])this.resolvedVersions.stream().filter(v -> includeSnapshots || !ArtifactUtils.isSnapshot((String)v.toString())).toArray(ArtifactVersion[]::new);
    }

    public String getName() {
        return this.name;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public boolean isAssociated() {
        return !this.associations.isEmpty();
    }

    public String toString() {
        return "PropertyVersions{" + (this.profileId == null ? "" : "profileId='" + this.profileId + "', ") + "name='" + this.name + '\'' + ", associations=" + this.associations + '}';
    }

    public ArtifactVersion getNewestVersion(String versionString, Property property, boolean allowSnapshots, Collection<MavenProject> reactorProjects, boolean allowDowngrade, Optional<Segment> upperBoundSegment) throws InvalidSegmentException, InvalidVersionSpecificationException {
        boolean includeSnapshots = !property.isBanSnapshots() && allowSnapshots;
        this.log.debug((CharSequence)("getNewestVersion(): includeSnapshots='" + includeSnapshots + "'"));
        this.log.debug((CharSequence)("Property ${" + property.getName() + "}: Set of valid available versions is " + Arrays.asList(this.getVersions(includeSnapshots))));
        VersionRange range = property.getVersion() != null ? VersionRange.createFromVersionSpec((String)property.getVersion()) : null;
        this.log.debug((CharSequence)("Property ${" + property.getName() + "}: Restricting results to " + range));
        ArtifactVersion currentVersion = ArtifactVersionService.getArtifactVersion(versionString);
        ArtifactVersion lowerBound = allowDowngrade ? (ArtifactVersion)this.getLowerBound(currentVersion, upperBoundSegment).map(ArtifactVersionService::getArtifactVersion).orElse(null) : currentVersion;
        this.log.debug((CharSequence)("lowerBoundArtifactVersion: " + lowerBound));
        ArtifactVersion upperBound = upperBoundSegment.isPresent() ? (ArtifactVersion)upperBoundSegment.map(s -> new BoundArtifactVersion(currentVersion, s.isMajorTo(Segment.SUBINCREMENTAL) ? Segment.minorTo(s) : s)).orElse(null) : null;
        this.log.debug((CharSequence)("Property ${" + property.getName() + "}: upperBound is: " + upperBound));
        Restriction restriction = new Restriction(lowerBound, allowDowngrade, upperBound, allowDowngrade);
        ArtifactVersion result = this.getNewestVersion(range, restriction, includeSnapshots);
        this.log.debug((CharSequence)("Property ${" + property.getName() + "}: Current winner is: " + result));
        if (property.isSearchReactor()) {
            this.log.debug((CharSequence)("Property ${" + property.getName() + "}: Searching reactor for a valid version..."));
            Set<Artifact> reactorArtifacts = reactorProjects.stream().map(MavenProject::getArtifact).collect(Collectors.toSet());
            ArtifactVersion[] reactorVersions = this.getVersions(reactorArtifacts);
            this.log.debug((CharSequence)("Property ${" + property.getName() + "}: Set of valid available versions from the reactor is " + Arrays.asList(reactorVersions)));
            ArtifactVersion fromReactor = Arrays.stream(reactorVersions).filter(version -> range == null || ArtifactVersions.isVersionInRange(version, range)).reduce((first, second) -> second).orElse(null);
            if (!(fromReactor == null || result != null && currentVersion.equals((Object)fromReactor.toString()))) {
                result = property.isPreferReactor() || result == null ? fromReactor : (result.compareTo((Object)fromReactor) < 0 ? fromReactor : result);
                this.log.debug((CharSequence)("Property ${" + property.getName() + "}: " + (result.equals((Object)fromReactor) ? "Reactor has a valid version" : "Reactor has the same or older version")));
            }
        }
        return result;
    }
}

